/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.InvocationsCallback;
import com.google.javascript.jscomp.MethodCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

class InlineSimpleMethods
extends MethodCompilerPass {
    private static final Logger logger = Logger.getLogger(InlineSimpleMethods.class.getName());
    static final MethodCompilerPass.SignatureStore DUMMY_SIGNATURE_STORE = new MethodCompilerPass.SignatureStore(){

        @Override
        public void addSignature(String string, Node node, String string2) {
        }

        @Override
        public void removeSignature(String string) {
        }

        @Override
        public void reset() {
        }
    };

    InlineSimpleMethods(AbstractCompiler abstractCompiler) {
        super(abstractCompiler);
    }

    @Override
    NodeTraversal.Callback getActingCallback() {
        return new InlineTrivialAccessors();
    }

    private static boolean isPropertyTree(Node node) {
        if (node.getType() != 33) {
            return false;
        }
        Node node2 = node.getFirstChild();
        if (node2.getType() != 42 && !InlineSimpleMethods.isPropertyTree(node2)) {
            return false;
        }
        Node node3 = node2.getNext();
        return NodeUtil.getStringValue(node3) != null;
    }

    private static void replaceThis(Node node, Node node2) {
        Node node3 = node.getFirstChild();
        if (node3.getType() == 42) {
            node.replaceChild(node3, node2);
        } else {
            InlineSimpleMethods.replaceThis(node3, node2);
        }
    }

    private static Node returnedExpression(Node node) {
        Node node2 = InlineSimpleMethods.getMethodBlock(node);
        if (!node2.hasOneChild()) {
            return null;
        }
        Node node3 = node2.getFirstChild();
        if (node3.getType() != 4) {
            return null;
        }
        if (!node3.hasOneChild()) {
            return null;
        }
        return node3.getLastChild();
    }

    private static boolean isEmptyMethod(Node node) {
        Node node2 = InlineSimpleMethods.getMethodBlock(node);
        return node2 == null ? false : NodeUtil.isEmptyBlock(node2);
    }

    private static Node getMethodBlock(Node node) {
        if (node.getChildCount() != 3) {
            return null;
        }
        Node node2 = node.getLastChild();
        return node2.getType() == 125 ? node2 : null;
    }

    private boolean allDefinitionsEquivalent(Collection<Node> collection) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(collection);
        Node node = (Node)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            if (this.compiler.areNodesEqualForInlining((Node)arrayList.get(i), node)) continue;
            return false;
        }
        return true;
    }

    private void inlinePropertyReturn(Node node, Node node2, Node node3) {
        Node node4 = node3.cloneTree();
        InlineSimpleMethods.replaceThis(node4, node2.getFirstChild().removeFirstChild());
        node.replaceChild(node2, node4);
        this.compiler.reportCodeChange();
    }

    private void inlineConstReturn(Node node, Node node2, Node node3) {
        Node node4 = node3.cloneTree();
        node.replaceChild(node2, node4);
        this.compiler.reportCodeChange();
    }

    private void inlineEmptyMethod(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (NodeUtil.isExprCall(node)) {
            node.getParent().replaceChild(node, new Node(124));
        } else {
            Node node3 = node2;
            node.replaceChild(node2, NodeUtil.newUndefinedNode(node3));
        }
        this.compiler.reportCodeChange();
    }

    private boolean argsMayHaveSideEffects(Node node) {
        for (Node node2 = node.getFirstChild().getNext(); node2 != null; node2 = node2.getNext()) {
            if (!NodeUtil.mayHaveSideEffects(node2)) continue;
            return true;
        }
        return false;
    }

    @Override
    MethodCompilerPass.SignatureStore getSignatureStore() {
        return DUMMY_SIGNATURE_STORE;
    }

    private class InlineTrivialAccessors
    extends InvocationsCallback {
        private InlineTrivialAccessors() {
        }

        @Override
        void visit(NodeTraversal nodeTraversal, Node node, Node node2, String string) {
            if (InlineSimpleMethods.this.externMethods.contains(string) || InlineSimpleMethods.this.nonMethodProperties.contains(string)) {
                return;
            }
            Collection collection = InlineSimpleMethods.this.methodDefinitions.get((Object)string);
            if (collection == null || collection.size() == 0) {
                return;
            }
            Node node3 = (Node)collection.iterator().next();
            if (collection.size() == 1 || InlineSimpleMethods.this.allDefinitionsEquivalent(collection)) {
                if (!InlineSimpleMethods.this.argsMayHaveSideEffects(node)) {
                    Node node4 = InlineSimpleMethods.returnedExpression(node3);
                    if (node4 != null) {
                        if (InlineSimpleMethods.isPropertyTree(node4)) {
                            logger.fine("Inlining property accessor: " + string);
                            InlineSimpleMethods.this.inlinePropertyReturn(node2, node, node4);
                        } else if (NodeUtil.isLiteralValue(node4, false) && !NodeUtil.mayHaveSideEffects(node.getFirstChild())) {
                            logger.fine("Inlining constant accessor: " + string);
                            InlineSimpleMethods.this.inlineConstReturn(node2, node, node4);
                        }
                    } else if (InlineSimpleMethods.isEmptyMethod(node3) && !NodeUtil.mayHaveSideEffects(node.getFirstChild())) {
                        logger.fine("Inlining empty method: " + string);
                        InlineSimpleMethods.this.inlineEmptyMethod(nodeTraversal, node2, node);
                    }
                }
            } else {
                logger.fine("Method '" + string + "' has conflicting definitions.");
            }
        }
    }
}

