/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class GatherSideEffectSubexpressionsCallback
implements NodeTraversal.Callback {
    private static final Set<Integer> FORBIDDEN_TYPES = ImmutableSet.of((Object)125, (Object)132, (Object)118, (Object)130, (Object)4);
    private final AbstractCompiler compiler;
    private final SideEffectAccumulator accumulator;

    GatherSideEffectSubexpressionsCallback(AbstractCompiler abstractCompiler, SideEffectAccumulator sideEffectAccumulator) {
        this.compiler = abstractCompiler;
        this.accumulator = sideEffectAccumulator;
    }

    private boolean isClassDefiningCall(Node node) {
        CodingConvention.SubclassRelationship subclassRelationship = this.compiler.getCodingConvention().getClassesDefinedByCall(node);
        return subclassRelationship != null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (FORBIDDEN_TYPES.contains(node.getType()) || NodeUtil.isControlStructure(node)) {
            throw new IllegalArgumentException(Token.name(node.getType()) + " nodes are not supported.");
        }
        if (node.getType() == 105) {
            return false;
        }
        if (node.getType() == 98) {
            return this.processHook(node);
        }
        if (node.getType() == 101 || node.getType() == 100) {
            return this.processShortCircuitExpression(node);
        }
        if (!NodeUtil.nodeTypeMayHaveSideEffects(node)) {
            return true;
        }
        if (node.getType() == 37) {
            return this.processFunctionCall(node);
        }
        if (node.getType() == 30) {
            return this.processConstructorCall(node);
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processShortCircuitExpression(Node node) {
        Preconditions.checkArgument((node.getType() == 101 || node.getType() == 100 ? 1 : 0) != 0, (Object)("Expected: AND or OR, Got: " + Token.name(node.getType())));
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        if (NodeUtil.mayHaveSideEffects(node3)) {
            this.accumulator.keepSimplifiedShortCircuitExpression(node);
            return false;
        }
        return true;
    }

    boolean processHook(Node node) {
        Preconditions.checkArgument((node.getType() == 98 ? 1 : 0) != 0, (Object)("Expected: HOOK, Got: " + Token.name(node.getType())));
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        Node node4 = node3.getNext();
        boolean bl = NodeUtil.mayHaveSideEffects(node3);
        boolean bl2 = NodeUtil.mayHaveSideEffects(node4);
        if (bl || bl2) {
            this.accumulator.keepSimplifiedHookExpression(node, bl, bl2);
            return false;
        }
        return true;
    }

    boolean processFunctionCall(Node node) {
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0, (Object)("Expected: CALL, Got: " + Token.name(node.getType())));
        Node node2 = node.getFirstChild();
        if ((NodeUtil.isName(node2) || NodeUtil.isGetProp(node2)) && !this.accumulator.classDefiningCallsHaveSideEffects() && this.isClassDefiningCall(node)) {
            return true;
        }
        if (!NodeUtil.functionCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processConstructorCall(Node node) {
        Preconditions.checkArgument((node.getType() == 30 ? 1 : 0) != 0, (Object)("Expected: NEW, Got: " + Token.name(node.getType())));
        if (!NodeUtil.constructorCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
    }

    static final class CopySideEffectSubexpressions
    implements SideEffectAccumulator {
        private final AbstractCompiler compiler;
        private final List<Node> replacements;

        CopySideEffectSubexpressions(AbstractCompiler abstractCompiler, List<Node> list) {
            this.compiler = abstractCompiler;
            this.replacements = list;
        }

        @Override
        public boolean classDefiningCallsHaveSideEffects() {
            return true;
        }

        @Override
        public void keepSubTree(Node node) {
            this.replacements.add(node.cloneTree());
        }

        @Override
        public void keepSimplifiedShortCircuitExpression(Node node) {
            Preconditions.checkArgument((node.getType() == 101 || node.getType() == 100 ? 1 : 0) != 0, (Object)("Expected: AND or OR, Got: " + Token.name(node.getType())));
            Node node2 = node.getFirstChild();
            Node node3 = node2.getNext();
            Node node4 = this.simplifyShortCircuitBranch(node3);
            Node node5 = node.cloneNode();
            node5.addChildToBack(node2.cloneTree());
            node5.addChildToBack(node4);
            this.replacements.add(node5);
        }

        @Override
        public void keepSimplifiedHookExpression(Node node, boolean bl, boolean bl2) {
            Preconditions.checkArgument((node.getType() == 98 ? 1 : 0) != 0, (Object)("Expected: HOOK, Got: " + Token.name(node.getType())));
            Node node2 = node.getFirstChild();
            Node node3 = node2.getNext();
            Node node4 = node3.getNext();
            if (bl && bl2) {
                Node node5 = node.cloneNode();
                node5.addChildToBack(node2.cloneTree());
                node5.addChildToBack(this.simplifyShortCircuitBranch(node3));
                node5.addChildToBack(this.simplifyShortCircuitBranch(node4));
                this.replacements.add(node5);
            } else if (bl || bl2) {
                int n = bl ? 101 : 100;
                Node node6 = bl ? node3 : node4;
                Node node7 = new Node(n, node2.cloneTree(), this.simplifyShortCircuitBranch(node6)).copyInformationFrom(node);
                this.replacements.add(node7);
            } else {
                throw new IllegalArgumentException("keepSimplifiedHookExpression must keep at least 1 branch");
            }
        }

        private Node simplifyShortCircuitBranch(Node node) {
            ArrayList arrayList = Lists.newArrayList();
            NodeTraversal.traverse(this.compiler, node, new GatherSideEffectSubexpressionsCallback(this.compiler, new CopySideEffectSubexpressions(this.compiler, arrayList)));
            Node node2 = null;
            for (Node node3 : arrayList) {
                if (node2 != null) {
                    node2 = new Node(85, node2, node3).copyInformationFrom(node);
                    continue;
                }
                node2 = node3;
            }
            if (node2 == null) {
                throw new IllegalArgumentException("expected at least one side effect subexpression in short circuit branch.");
            }
            return node2;
        }
    }

    static interface SideEffectAccumulator {
        public boolean classDefiningCallsHaveSideEffects();

        public void keepSubTree(Node var1);

        public void keepSimplifiedShortCircuitExpression(Node var1);

        public void keepSimplifiedHookExpression(Node var1, boolean var2, boolean var3);
    }
}

