/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConcreteType;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TightenTypes;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.jscomp.graph.UnionFind;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;

class DisambiguateProperties<T>
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(DisambiguateProperties.class.getName());
    static final DiagnosticType INVALIDATION = DiagnosticType.warning("JSC_INVALIDATION", "Property disambiguator skipping all instances of property {0} because of type {1} node {2}");
    private final boolean showInvalidationWarnings = false;
    private final AbstractCompiler compiler;
    private final TypeSystem<T> typeSystem;
    private Map<String, Property> properties = Maps.newHashMap();

    static DisambiguateProperties<JSType> forJSTypeSystem(AbstractCompiler abstractCompiler) {
        return new DisambiguateProperties<JSType>(abstractCompiler, new JSTypeSystem(abstractCompiler));
    }

    static DisambiguateProperties<ConcreteType> forConcreteTypeSystem(AbstractCompiler abstractCompiler, TightenTypes tightenTypes) {
        return new DisambiguateProperties<ConcreteType>(abstractCompiler, new ConcreteTypeSystem(tightenTypes, abstractCompiler.getCodingConvention()));
    }

    private DisambiguateProperties(AbstractCompiler abstractCompiler, TypeSystem<T> typeSystem) {
        this.compiler = abstractCompiler;
        this.typeSystem = typeSystem;
    }

    @Override
    public void process(Node node, Node node2) {
        for (TypeValidator.TypeMismatch typeMismatch : this.compiler.getTypeValidator().getMismatches()) {
            this.addInvalidatingType(typeMismatch.typeA);
            this.addInvalidatingType(typeMismatch.typeB);
        }
        StaticScope<T> staticScope = this.typeSystem.getRootScope();
        NodeTraversal.traverse(this.compiler, node, new FindExternProperties());
        NodeTraversal.traverse(this.compiler, node2, new FindRenameableProperties());
        this.renameProperties();
    }

    private void addInvalidatingType(JSType jSType) {
        if ((jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType) {
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                this.addInvalidatingType(jSType2);
            }
            return;
        }
        this.typeSystem.addInvalidatingType(jSType);
        ObjectType objectType = ObjectType.cast(jSType);
        if (objectType != null && objectType.getImplicitPrototype() != null) {
            this.typeSystem.addInvalidatingType(objectType.getImplicitPrototype());
        }
    }

    protected Property getProperty(String string) {
        if (!this.properties.containsKey(string)) {
            this.properties.put(string, new Property(string));
        }
        return this.properties.get(string);
    }

    T getTypeWithProperty(String string, T t) {
        return this.typeSystem.getTypeWithProperty(string, t);
    }

    void renameProperties() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (Property property : this.properties.values()) {
            if (property.shouldRename()) {
                Map map = this.buildPropNames(property.getTypes(), property.name);
                ++n;
                property.expandTypesToSkip();
                UnionFind unionFind = property.getTypes();
                for (Node node : property.renameNodes) {
                    Object t = property.rootTypes.get(node);
                    if (property.shouldRename(t)) {
                        String string = map.get(t);
                        node.setString(string);
                        this.compiler.reportCodeChange();
                        ++n3;
                        continue;
                    }
                    ++n4;
                }
                continue;
            }
            if (property.skipRenaming) {
                ++n2;
                continue;
            }
            ++n5;
        }
        logger.info("Renamed " + n3 + " instances of " + n + " properties.");
        logger.info("Skipped renaming " + n4 + " invalidated " + "properties, " + n2 + " instances of properties " + "that were skipped for specific types and " + n5 + " properties that were referenced from only one type.");
    }

    private Map<T, String> buildPropNames(UnionFind<T> unionFind, String string) {
        HashMap hashMap = Maps.newHashMap();
        for (Set<T> set : unionFind.allEquivalenceClasses()) {
            Object object2;
            Preconditions.checkState((!set.isEmpty() ? 1 : 0) != 0);
            String string2 = null;
            for (Object object2 : set) {
                if (string2 != null && object2.toString().compareTo(string2) >= 0) continue;
                string2 = object2.toString();
            }
            String string3 = "{...}".equals(string2) ? string : string2.replaceAll("[^\\w$]", "_") + "$" + string;
            object2 = set.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                hashMap.put(e, string3);
            }
        }
        return hashMap;
    }

    Multimap<String, Collection<T>> getRenamedTypesForTesting() {
        HashMultimap hashMultimap = HashMultimap.create();
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            Property property = entry.getValue();
            if (property.skipRenaming) continue;
            for (Set set : property.getTypes().allEquivalenceClasses()) {
                if (set.isEmpty() || property.typesToSkip.contains(set.iterator().next())) continue;
                hashMultimap.put((Object)entry.getKey(), set);
            }
        }
        return hashMultimap;
    }

    private static class ConcreteTypeSystem
    implements TypeSystem<ConcreteType> {
        private final TightenTypes tt;
        private int nextUniqueId;
        private CodingConvention codingConvention;
        private final Set<JSType> invalidatingTypes = Sets.newHashSet();
        private static final JSTypeNative[] nativeTypes = new JSTypeNative[]{JSTypeNative.BOOLEAN_OBJECT_TYPE, JSTypeNative.NUMBER_OBJECT_TYPE, JSTypeNative.STRING_OBJECT_TYPE};

        public ConcreteTypeSystem(TightenTypes tightenTypes, CodingConvention codingConvention) {
            this.tt = tightenTypes;
            this.codingConvention = codingConvention;
        }

        @Override
        public void addInvalidatingType(JSType jSType) {
            Preconditions.checkState((!jSType.isUnionType() ? 1 : 0) != 0);
            this.invalidatingTypes.add(jSType);
        }

        @Override
        public StaticScope<ConcreteType> getRootScope() {
            return this.tt.getTopScope();
        }

        @Override
        public StaticScope<ConcreteType> getFunctionScope(Node node) {
            ConcreteType.ConcreteFunctionType concreteFunctionType = this.tt.getConcreteFunction(node);
            return concreteFunctionType != null ? concreteFunctionType.getScope() : (StaticScope)null;
        }

        @Override
        public ConcreteType getType(StaticScope<ConcreteType> staticScope, Node node, String string) {
            if (staticScope != null) {
                ConcreteType concreteType = this.tt.inferConcreteType((TightenTypes.ConcreteScope)staticScope, node);
                return this.maybeAddAutoboxes(concreteType, node, string);
            }
            return null;
        }

        private ConcreteType maybeAddAutoboxes(ConcreteType concreteType, Node node, String string) {
            JSType jSType = node.getJSType();
            if (jSType == null) {
                return concreteType;
            }
            if (jSType.isUnknownType()) {
                for (JSTypeNative jSTypeNative : nativeTypes) {
                    ConcreteType.ConcreteInstanceType concreteInstanceType = this.tt.getConcreteInstance(this.tt.getTypeRegistry().getNativeObjectType(jSTypeNative));
                    if (concreteInstanceType == null || concreteInstanceType.getPropertyType(string).isNone()) continue;
                    concreteType = concreteType.unionWith(concreteInstanceType);
                }
                return concreteType;
            }
            return this.maybeAddAutoboxes(concreteType, jSType, string);
        }

        private ConcreteType maybeAddAutoboxes(ConcreteType concreteType, JSType jSType, String string) {
            Object object;
            if ((jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType && (object = ((UnionType)jSType).getAlternates().iterator()).hasNext()) {
                JSType jSType2 = (JSType)object.next();
                return this.maybeAddAutoboxes(concreteType, jSType2, string);
            }
            if (jSType.autoboxesTo() != null) {
                object = jSType.autoboxesTo();
                return concreteType.unionWith(this.tt.getConcreteInstance((ObjectType)object));
            }
            if (jSType.unboxesTo() != null) {
                return concreteType.unionWith(this.tt.getConcreteInstance((ObjectType)jSType));
            }
            return concreteType;
        }

        @Override
        public boolean isInvalidatingType(ConcreteType concreteType) {
            return concreteType == null || concreteType.isAll() || concreteType.isFunction() || concreteType.isInstance() && this.invalidatingTypes.contains(concreteType.toInstance().instanceType);
        }

        @Override
        public ImmutableSet<ConcreteType> getTypesToSkipForType(ConcreteType concreteType) {
            return ImmutableSet.of((Object)concreteType);
        }

        @Override
        public boolean isTypeToSkip(ConcreteType concreteType) {
            return concreteType.isInstance() && !concreteType.toInstance().isFunctionPrototype() && !concreteType.toInstance().instanceType.isInstanceType();
        }

        @Override
        public ConcreteType restrictByNotNullOrUndefined(ConcreteType concreteType) {
            return concreteType;
        }

        @Override
        public Iterable<ConcreteType> getTypeAlternatives(ConcreteType concreteType) {
            if (concreteType.isUnion()) {
                return ((ConcreteType.ConcreteUnionType)concreteType).getAlternatives();
            }
            return null;
        }

        @Override
        public ConcreteType getTypeWithProperty(String string, ConcreteType concreteType) {
            if (concreteType.isInstance()) {
                ConcreteType.ConcreteInstanceType concreteInstanceType = (ConcreteType.ConcreteInstanceType)concreteType;
                return concreteInstanceType.getInstanceTypeWithProperty(string);
            }
            if (concreteType.isFunction()) {
                if ("prototype".equals(string) || this.codingConvention.isSuperClassReference(string)) {
                    return concreteType;
                }
            } else {
                if (concreteType.isNone()) {
                    return new ConcreteType.ConcreteUniqueType(++this.nextUniqueId);
                }
                if (concreteType.isUnion()) {
                    for (ConcreteType concreteType2 : ((ConcreteType.ConcreteUnionType)concreteType).getAlternatives()) {
                        ConcreteType concreteType3 = this.getTypeWithProperty(string, concreteType2);
                        if (concreteType3 == null) continue;
                        return concreteType3;
                    }
                }
            }
            return null;
        }

        @Override
        public ConcreteType getInstanceFromPrototype(ConcreteType concreteType) {
            ConcreteType.ConcreteInstanceType concreteInstanceType;
            if (concreteType.isInstance() && (concreteInstanceType = (ConcreteType.ConcreteInstanceType)concreteType).isFunctionPrototype()) {
                return concreteInstanceType.getConstructorType().getInstanceType();
            }
            return null;
        }

        @Override
        public void recordInterfaces(ConcreteType concreteType, ConcreteType concreteType2, Property property) {
        }
    }

    private static class JSTypeSystem
    implements TypeSystem<JSType> {
        private final Set<JSType> invalidatingTypes;
        private JSTypeRegistry registry;

        public JSTypeSystem(AbstractCompiler abstractCompiler) {
            this.registry = abstractCompiler.getTypeRegistry();
            this.invalidatingTypes = Sets.newHashSet((Object[])new JSType[]{this.registry.getNativeType(JSTypeNative.ALL_TYPE), this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE), this.registry.getNativeType(JSTypeNative.NO_TYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), this.registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE), this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)});
        }

        @Override
        public void addInvalidatingType(JSType jSType) {
            Preconditions.checkState((!jSType.isUnionType() ? 1 : 0) != 0);
            this.invalidatingTypes.add(jSType);
        }

        @Override
        public StaticScope<JSType> getRootScope() {
            return null;
        }

        @Override
        public StaticScope<JSType> getFunctionScope(Node node) {
            return null;
        }

        @Override
        public JSType getType(StaticScope<JSType> staticScope, Node node, String string) {
            if (node.getJSType() == null) {
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return node.getJSType();
        }

        @Override
        public boolean isInvalidatingType(JSType jSType) {
            if (jSType == null || this.invalidatingTypes.contains(jSType) || jSType.isUnknownType()) {
                return true;
            }
            ObjectType objectType = ObjectType.cast(jSType);
            return objectType != null && !objectType.hasReferenceName();
        }

        @Override
        public ImmutableSet<JSType> getTypesToSkipForType(JSType jSType) {
            if ((jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType) {
                HashSet hashSet = Sets.newHashSet((Object[])new JSType[]{jSType});
                for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                    hashSet.addAll(this.getTypesToSkipForTypeNonUnion(jSType));
                }
                return ImmutableSet.copyOf((Collection)hashSet);
            }
            return ImmutableSet.copyOf(this.getTypesToSkipForTypeNonUnion(jSType));
        }

        private Set<JSType> getTypesToSkipForTypeNonUnion(JSType jSType) {
            HashSet hashSet = Sets.newHashSet();
            JSType jSType2 = jSType;
            while (jSType2 != null) {
                hashSet.add(jSType2);
                ObjectType objectType = jSType2.toObjectType();
                if (objectType == null) break;
                jSType2 = objectType.getImplicitPrototype();
            }
            return hashSet;
        }

        @Override
        public boolean isTypeToSkip(JSType jSType) {
            return jSType.isEnumType() || jSType.autoboxesTo() != null;
        }

        @Override
        public JSType restrictByNotNullOrUndefined(JSType jSType) {
            return jSType.restrictByNotNullOrUndefined();
        }

        @Override
        public Iterable<JSType> getTypeAlternatives(JSType jSType) {
            if (jSType.isUnionType()) {
                return ((UnionType)jSType).getAlternates();
            }
            ObjectType objectType = jSType.toObjectType();
            if (objectType != null && objectType.getConstructor() != null && objectType.getConstructor().isInterface()) {
                ArrayList arrayList = Lists.newArrayList();
                for (FunctionType functionType : this.registry.getDirectImplementors(objectType)) {
                    arrayList.add(functionType.getInstanceType());
                }
                return arrayList;
            }
            return null;
        }

        @Override
        public ObjectType getTypeWithProperty(String string, JSType jSType) {
            ObjectType objectType;
            if (!(jSType instanceof ObjectType)) {
                if (jSType.autoboxesTo() != null) {
                    jSType = jSType.autoboxesTo();
                } else {
                    return null;
                }
            }
            if ("prototype".equals(string)) {
                return null;
            }
            ObjectType objectType2 = null;
            for (ObjectType objectType3 = ObjectType.cast(jSType); objectType3 != null && objectType3.getImplicitPrototype() != objectType3; objectType3 = objectType3.getImplicitPrototype()) {
                if (!objectType3.hasOwnProperty(string)) continue;
                objectType2 = objectType3;
            }
            if (objectType2 == null && (objectType = ObjectType.cast(this.registry.getGreatestSubtypeWithProperty(jSType, string))) != null && objectType.hasOwnProperty(string)) {
                objectType2 = objectType;
            }
            return objectType2;
        }

        @Override
        public JSType getInstanceFromPrototype(JSType jSType) {
            FunctionPrototypeType functionPrototypeType;
            FunctionType functionType;
            if (jSType.isFunctionPrototypeType() && ((functionType = (functionPrototypeType = (FunctionPrototypeType)jSType).getOwnerFunction()).isConstructor() || functionType.isInterface())) {
                return ((FunctionPrototypeType)jSType).getOwnerFunction().getInstanceType();
            }
            return null;
        }

        @Override
        public void recordInterfaces(JSType jSType, JSType jSType2, Property property) {
            ObjectType objectType = ObjectType.cast(jSType);
            if (objectType != null) {
                FunctionType functionType = objectType instanceof FunctionType ? (FunctionType)objectType : (objectType instanceof FunctionPrototypeType ? ((FunctionPrototypeType)objectType).getOwnerFunction() : objectType.getConstructor());
                while (functionType != null) {
                    for (ObjectType objectType2 : functionType.getImplementedInterfaces()) {
                        ObjectType objectType3 = this.getTypeWithProperty(property.name, objectType2);
                        if (objectType3 != null) {
                            property.addType(objectType2, objectType3, jSType2);
                        } else {
                            this.recordInterfaces(objectType2, jSType2, property);
                        }
                        if (!property.skipRenaming) continue;
                        return;
                    }
                    if (functionType.isInterface() || functionType.isConstructor()) {
                        functionType = functionType.getSuperClassConstructor();
                        continue;
                    }
                    functionType = null;
                }
            }
        }
    }

    private static interface TypeSystem<T> {
        public StaticScope<T> getRootScope();

        public StaticScope<T> getFunctionScope(Node var1);

        public T getType(StaticScope<T> var1, Node var2, String var3);

        public boolean isInvalidatingType(T var1);

        public void addInvalidatingType(JSType var1);

        public ImmutableSet<T> getTypesToSkipForType(T var1);

        public boolean isTypeToSkip(T var1);

        public T restrictByNotNullOrUndefined(T var1);

        public Iterable<T> getTypeAlternatives(T var1);

        public T getTypeWithProperty(String var1, T var2);

        public T getInstanceFromPrototype(T var1);

        public void recordInterfaces(T var1, T var2, Property var3);
    }

    private class FindRenameableProperties
    extends AbstractScopingCallback {
        private FindRenameableProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 33) {
                this.handleGetProp(nodeTraversal, node);
            } else if (node.getType() == 64) {
                this.handleObjectLit(nodeTraversal, node);
            }
        }

        private void handleGetProp(NodeTraversal nodeTraversal, Node node) {
            String string = node.getLastChild().getString();
            Object t = DisambiguateProperties.this.typeSystem.getType(this.getScope(), node.getFirstChild(), string);
            Property property = DisambiguateProperties.this.getProperty(string);
            if (!property.scheduleRenaming(node.getLastChild(), this.processProperty(nodeTraversal, property, t, null))) {
                // empty if block
            }
        }

        private void handleObjectLit(NodeTraversal nodeTraversal, Node node) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getType() != 40) continue;
                String string = node2.getString();
                Object t = DisambiguateProperties.this.typeSystem.getType(this.getScope(), node, string);
                Property property = DisambiguateProperties.this.getProperty(string);
                if (property.scheduleRenaming(node2, this.processProperty(nodeTraversal, property, t, null))) continue;
            }
        }

        private T processProperty(NodeTraversal nodeTraversal, Property property, T t, T t2) {
            t = DisambiguateProperties.this.typeSystem.restrictByNotNullOrUndefined(t);
            if (property.skipRenaming || DisambiguateProperties.this.typeSystem.isInvalidatingType(t)) {
                return null;
            }
            Iterable iterable = DisambiguateProperties.this.typeSystem.getTypeAlternatives(t);
            if (iterable != null) {
                Object t3 = t2;
                for (Object t4 : iterable) {
                    Object t5 = this.processProperty(nodeTraversal, property, t4, t3);
                    if (t5 == null) continue;
                    t3 = t3 == null ? t5 : t3;
                }
                return t3;
            }
            Object t6 = DisambiguateProperties.this.typeSystem.getTypeWithProperty(property.name, t);
            if (DisambiguateProperties.this.typeSystem.isInvalidatingType(t6)) {
                return null;
            }
            property.addType(t, t6, t2);
            return t6;
        }
    }

    private class FindExternProperties
    extends AbstractScopingCallback {
        private FindExternProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 33) {
                String string = node.getLastChild().getString();
                Object t = DisambiguateProperties.this.typeSystem.getType(this.getScope(), node.getFirstChild(), string);
                Property property = DisambiguateProperties.this.getProperty(string);
                if (DisambiguateProperties.this.typeSystem.isInvalidatingType(t)) {
                    property.invalidate();
                } else {
                    property.addTypeToSkip(t);
                    t = DisambiguateProperties.this.typeSystem.getInstanceFromPrototype(t);
                    if (t != null) {
                        property.getTypes().add(t);
                        property.typesToSkip.add(t);
                    }
                }
            }
        }
    }

    private abstract class AbstractScopingCallback
    implements NodeTraversal.ScopedCallback {
        protected final Stack<StaticScope<T>> scopes = new Stack();

        private AbstractScopingCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.inGlobalScope()) {
                this.scopes.push(DisambiguateProperties.this.typeSystem.getRootScope());
            } else {
                this.scopes.push(DisambiguateProperties.this.typeSystem.getFunctionScope(nodeTraversal.getScopeRoot()));
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            this.scopes.pop();
        }

        protected StaticScope<T> getScope() {
            return this.scopes.peek();
        }
    }

    private class Property {
        final String name;
        private UnionFind<T> types;
        Set<T> typesToSkip = Sets.newHashSet();
        boolean skipRenaming;
        Set<Node> renameNodes = Sets.newHashSet();
        final Map<Node, T> rootTypes = Maps.newHashMap();

        Property(String string) {
            this.name = string;
        }

        UnionFind<T> getTypes() {
            if (this.types == null) {
                this.types = new StandardUnionFind();
            }
            return this.types;
        }

        boolean addType(T t, T t2, T t3) {
            Preconditions.checkState((!this.skipRenaming ? 1 : 0) != 0, (String)"Attempt to record skipped property: %s", (Object[])new Object[]{this.name});
            if (DisambiguateProperties.this.typeSystem.isInvalidatingType(t2)) {
                this.invalidate();
                return false;
            }
            if (DisambiguateProperties.this.typeSystem.isTypeToSkip(t2)) {
                this.addTypeToSkip(t2);
            }
            if (t3 == null) {
                this.getTypes().add(t2);
            } else {
                this.getTypes().union(t2, t3);
            }
            DisambiguateProperties.this.typeSystem.recordInterfaces(t, t2, this);
            return true;
        }

        void addTypeToSkip(T t) {
            for (Object e : DisambiguateProperties.this.typeSystem.getTypesToSkipForType(t)) {
                this.typesToSkip.add(e);
                this.getTypes().union(e, t);
            }
        }

        void expandTypesToSkip() {
            block4: {
                int n;
                if (!this.shouldRename()) break block4;
                int n2 = 0;
                do {
                    Object e;
                    Object object2;
                    Preconditions.checkState((++n2 < 10 ? 1 : 0) != 0, (Object)"Stuck in loop expanding types to skip.");
                    HashSet hashSet = Sets.newHashSet();
                    for (Object object2 : this.typesToSkip) {
                        hashSet.add(this.types.find(object2));
                    }
                    this.typesToSkip.addAll(hashSet);
                    HashSet hashSet2 = Sets.newHashSet();
                    object2 = this.types.elements();
                    n = object2.size();
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (this.typesToSkip.contains(e) || !this.typesToSkip.contains(this.types.find(e))) continue;
                        hashSet2.add(e);
                    }
                    iterator = hashSet2.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        this.addTypeToSkip(e);
                    }
                } while (this.types.elements().size() != n);
            }
        }

        boolean shouldRename() {
            return !this.skipRenaming && this.types != null && this.types.allEquivalenceClasses().size() > 1;
        }

        boolean shouldRename(T t) {
            return !this.skipRenaming && !this.typesToSkip.contains(t);
        }

        boolean invalidate() {
            boolean bl = !this.skipRenaming;
            this.skipRenaming = true;
            this.types = null;
            return bl;
        }

        boolean scheduleRenaming(Node node, T t) {
            if (!this.skipRenaming) {
                if (DisambiguateProperties.this.typeSystem.isInvalidatingType(t)) {
                    this.invalidate();
                    return false;
                }
                this.renameNodes.add(node);
                this.rootTypes.put(node, t);
            }
            return true;
        }
    }
}

