/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;

class DeadAssignmentsElimination
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private LiveVariablesAnalysis liveness;
    private static final Predicate<Node> matchRemovableAssigns = new Predicate<Node>(){

        public boolean apply(Node node) {
            return NodeUtil.isAssignmentOp(node) && node.getFirstChild().getType() == 38 || node.getType() == 102 || node.getType() == 103;
        }
    };

    public DeadAssignmentsElimination(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)node2);
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Scope scope = nodeTraversal.getScope();
        if (scope.isGlobal()) {
            return;
        }
        Node node = nodeTraversal.getScopeRoot().getLastChild();
        if (NodeUtil.containsFunction(node)) {
            return;
        }
        if (!NodeUtil.has(node, matchRemovableAssigns, (Predicate<Node>)Predicates.alwaysTrue())) {
            return;
        }
        ControlFlowGraph<Node> controlFlowGraph = nodeTraversal.getControlFlowGraph();
        this.liveness = new LiveVariablesAnalysis(controlFlowGraph, scope, this.compiler);
        this.liveness.analyze();
        this.tryRemoveDeadAssignments(nodeTraversal, controlFlowGraph);
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
    }

    private void tryRemoveDeadAssignments(NodeTraversal nodeTraversal, ControlFlowGraph<Node> controlFlowGraph) {
        Iterable iterable = controlFlowGraph.getDirectedGraphNodes();
        block5: for (DiGraph.DiGraphNode diGraphNode : iterable) {
            DataFlowAnalysis.FlowState flowState = (DataFlowAnalysis.FlowState)diGraphNode.getAnnotation();
            Node node = (Node)diGraphNode.getValue();
            if (node == null) continue;
            switch (node.getType()) {
                case 108: 
                case 113: 
                case 114: {
                    this.tryRemoveAssignment(nodeTraversal, NodeUtil.getConditionExpression(node), flowState);
                    continue block5;
                }
                case 115: {
                    if (NodeUtil.isForIn(node)) continue block5;
                    this.tryRemoveAssignment(nodeTraversal, NodeUtil.getConditionExpression(node), flowState);
                    continue block5;
                }
                case 4: 
                case 110: 
                case 111: {
                    if (!node.hasChildren()) continue block5;
                    this.tryRemoveAssignment(nodeTraversal, node.getFirstChild(), flowState);
                    continue block5;
                }
            }
            this.tryRemoveAssignment(nodeTraversal, node, flowState);
        }
    }

    private void tryRemoveAssignment(NodeTraversal nodeTraversal, Node node, DataFlowAnalysis.FlowState<LiveVariablesAnalysis.LiveVariableLattice> flowState) {
        this.tryRemoveAssignment(nodeTraversal, node, node, flowState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryRemoveAssignment(NodeTraversal nodeTraversal, Node node, Node node2, DataFlowAnalysis.FlowState<LiveVariablesAnalysis.LiveVariableLattice> flowState) {
        Node node3 = node.getParent();
        if (NodeUtil.isAssignmentOp(node) || node.getType() == 102 || node.getType() == 103) {
            Node node4 = node.getFirstChild();
            Node node5 = node4.getNext();
            if (node5 != null) {
                this.tryRemoveAssignment(nodeTraversal, node5, node2, flowState);
                node5 = node4.getNext();
            }
            Scope scope = nodeTraversal.getScope();
            if (!NodeUtil.isName(node4)) {
                return;
            }
            String string = node4.getString();
            if (!scope.isDeclared(string, false)) {
                return;
            }
            Scope.Var var = scope.getVar(string);
            if (this.liveness.getEscapedLocals().contains(var)) {
                return;
            }
            if (node5 != null && NodeUtil.isName(node5) && node5.getString().equals(var.name) && NodeUtil.isAssign(node)) {
                node.removeChild(node5);
                node.getParent().replaceChild(node, node5);
                this.compiler.reportCodeChange();
                return;
            }
            if (flowState.getOut().isLive(var)) {
                return;
            }
            if (flowState.getIn().isLive(var) && this.isVariableStillLiveWithinExpression(node, node2, var.name)) {
                return;
            }
            if (NodeUtil.isAssign(node)) {
                node.removeChild(node5);
                node.getParent().replaceChild(node, node5);
            } else if (NodeUtil.isAssignmentOp(node)) {
                node.removeChild(node5);
                node.removeChild(node4);
                Node node6 = new Node(NodeUtil.getOpFromAssignmentOp(node), node4, node5);
                node3.replaceChild(node, node6);
            } else if (node.getType() == 102 || node.getType() == 103) {
                if (NodeUtil.isExpressionNode(node3)) {
                    node3.replaceChild(node, new Node(122, Node.newNumber(0.0).copyInformationFrom(node)));
                } else if (node.getType() == 85 && node != node3.getLastChild()) {
                    node3.removeChild(node);
                } else {
                    if (node3.getType() != 115 || NodeUtil.isForIn(node3) || NodeUtil.getConditionExpression(node3) == node) return;
                    node3.replaceChild(node, new Node(124));
                }
            } else {
                Preconditions.checkState((boolean)false, (Object)"Unknown statement");
            }
            this.compiler.reportCodeChange();
            return;
        }
        Node node7 = node.getFirstChild();
        while (node7 != null) {
            Node node8 = node7.getNext();
            if (!ControlFlowGraph.isEnteringNewCfgNode(node7)) {
                this.tryRemoveAssignment(nodeTraversal, node7, node2, flowState);
            }
            node7 = node8;
        }
    }

    private boolean isVariableStillLiveWithinExpression(Node node, Node node2, String string) {
        while (node != node2) {
            for (Node node3 = node.getNext(); node3 != null; node3 = node3.getNext()) {
                if (ControlFlowGraph.isEnteringNewCfgNode(node3)) continue;
                VariableLiveness variableLiveness = this.isVariableReadBeforeKill(node3, string);
                if (variableLiveness == VariableLiveness.READ) {
                    return true;
                }
                if (variableLiveness != VariableLiveness.KILL) continue;
                return false;
            }
            node = node.getParent();
        }
        return false;
    }

    private VariableLiveness isVariableReadBeforeKill(Node node, String string) {
        if (NodeUtil.isName(node) && string.equals(node.getString())) {
            if (NodeUtil.isLhs(node, node.getParent())) {
                Preconditions.checkState((node.getParent().getType() == 86 ? 1 : 0) != 0);
                Node node2 = node.getNext();
                VariableLiveness variableLiveness = this.isVariableReadBeforeKill(node2, string);
                if (variableLiveness == VariableLiveness.READ) {
                    return variableLiveness;
                }
                return VariableLiveness.KILL;
            }
            return VariableLiveness.READ;
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            VariableLiveness variableLiveness;
            if (ControlFlowGraph.isEnteringNewCfgNode(node3) || (variableLiveness = this.isVariableReadBeforeKill(node3, string)) == VariableLiveness.MAYBE_LIVE) continue;
            return variableLiveness;
        }
        return VariableLiveness.MAYBE_LIVE;
    }

    private static enum VariableLiveness {
        MAYBE_LIVE,
        READ,
        KILL;

    }
}

