/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.Comparator;

class ControlFlowGraph<N>
extends LinkedDirectedGraph<N, Branch> {
    private final DiGraph.DiGraphNode<N, Branch> implicitReturn = this.createDirectedGraphNode(null);
    private final DiGraph.DiGraphNode<N, Branch> entry;

    ControlFlowGraph(N n, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.entry = this.createDirectedGraphNode(n);
    }

    public DiGraph.DiGraphNode<N, Branch> getImplicitReturn() {
        return this.implicitReturn;
    }

    public DiGraph.DiGraphNode<N, Branch> getEntry() {
        return this.entry;
    }

    public boolean isImplicitReturn(DiGraph.DiGraphNode<N, Branch> diGraphNode) {
        return diGraphNode == this.implicitReturn;
    }

    public void connectToImplicitReturn(N n, Branch branch) {
        super.connect(n, branch, null);
    }

    public Comparator<DiGraph.DiGraphNode<N, Branch>> getOptionalNodeComparator(boolean bl) {
        return null;
    }

    public static boolean isEnteringNewCfgNode(Node node) {
        Node node2 = node.getParent();
        switch (node2.getType()) {
            case 77: 
            case 121: 
            case 125: 
            case 132: {
                return true;
            }
            case 105: {
                return node != node2.getFirstChild().getNext();
            }
            case 108: 
            case 113: 
            case 114: {
                return NodeUtil.getConditionExpression(node2) != node;
            }
            case 115: {
                if (NodeUtil.isForIn(node2)) {
                    return node == node2.getLastChild();
                }
                return NodeUtil.getConditionExpression(node2) != node;
            }
            case 110: 
            case 111: 
            case 119: 
            case 120: {
                return node != node2.getFirstChild();
            }
        }
        return false;
    }

    public static abstract class AbstractCfgNodeTraversalCallback
    implements NodeTraversal.Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node2 == null) {
                return true;
            }
            return !ControlFlowGraph.isEnteringNewCfgNode(node);
        }
    }

    public static enum Branch {
        ON_TRUE,
        ON_FALSE,
        UNCOND,
        ON_EX,
        SYN_BLOCK;


        public boolean isConditional() {
            return this == ON_TRUE || this == ON_FALSE;
        }
    }
}

