/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

final class ControlFlowAnalysis
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private ControlFlowGraph<Node> cfg;
    private Map<Node, Integer> astPosition;
    private Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> nodePriorities;
    private final Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> priorityComparator = new Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

        @Override
        public int compare(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode, DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode2) {
            return (Integer)ControlFlowAnalysis.this.astPosition.get(diGraphNode.getValue()) - (Integer)ControlFlowAnalysis.this.astPosition.get(diGraphNode2.getValue());
        }
    };
    private int astPositionCounter;
    private int priorityCounter;
    private final boolean shouldTraverseFunctions;
    private final boolean edgeAnnotations;
    private Node root;
    private final Deque<Node> exceptionHandler = new ArrayDeque<Node>();
    private final Multimap<Node, Node> finallyMap = HashMultimap.create();

    ControlFlowAnalysis(AbstractCompiler abstractCompiler, boolean bl, boolean bl2) {
        this.compiler = abstractCompiler;
        this.shouldTraverseFunctions = bl;
        this.edgeAnnotations = bl2;
    }

    ControlFlowGraph<Node> getCfg() {
        return this.cfg;
    }

    @Override
    public void process(Node node, Node node2) {
        this.root = node2;
        this.astPositionCounter = 0;
        this.astPosition = Maps.newHashMap();
        this.nodePriorities = Maps.newHashMap();
        this.cfg = new AstControlFlowGraph(ControlFlowAnalysis.computeFallThrough(node2), this.nodePriorities, this.edgeAnnotations);
        NodeTraversal.traverse(this.compiler, node2, this);
        this.astPosition.put(null, ++this.astPositionCounter);
        this.priorityCounter = 0;
        DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode = this.cfg.getEntry();
        this.prioritizeFromEntryNode(diGraphNode);
        if (this.shouldTraverseFunctions) {
            for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode2 : this.cfg.getDirectedGraphNodes()) {
                Node node3 = (Node)diGraphNode2.getValue();
                if (node3 == null || node3.getType() != 105) continue;
                Preconditions.checkState((!this.nodePriorities.containsKey(diGraphNode2) || diGraphNode2 == diGraphNode ? 1 : 0) != 0);
                this.prioritizeFromEntryNode(diGraphNode2);
            }
        }
        for (DiGraph.DiGraphNode diGraphNode2 : this.cfg.getDirectedGraphNodes()) {
            if (this.nodePriorities.containsKey(diGraphNode2)) continue;
            this.nodePriorities.put(diGraphNode2, ++this.priorityCounter);
        }
        this.nodePriorities.put(this.cfg.getImplicitReturn(), ++this.priorityCounter);
    }

    private void prioritizeFromEntryNode(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode) {
        PriorityQueue<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> priorityQueue = new PriorityQueue<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(10, this.priorityComparator);
        priorityQueue.add(diGraphNode);
        while (!priorityQueue.isEmpty()) {
            DiGraph.DiGraphNode diGraphNode2 = (DiGraph.DiGraphNode)priorityQueue.remove();
            if (this.nodePriorities.containsKey(diGraphNode2)) continue;
            this.nodePriorities.put(diGraphNode2, ++this.priorityCounter);
            List list = this.cfg.getDirectedSuccNodes(diGraphNode2);
            for (DiGraph.DiGraphNode diGraphNode3 : list) {
                priorityQueue.add(diGraphNode3);
            }
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        this.astPosition.put(node, this.astPositionCounter++);
        switch (node.getType()) {
            case 105: {
                if (this.shouldTraverseFunctions || node == this.cfg.getEntry().getValue()) {
                    this.exceptionHandler.push(node);
                    return true;
                }
                return false;
            }
            case 77: {
                this.exceptionHandler.push(node);
                return true;
            }
        }
        if (node2 != null) {
            switch (node2.getType()) {
                case 115: {
                    return node == node2.getLastChild();
                }
                case 108: 
                case 113: 
                case 119: {
                    return node != node2.getFirstChild();
                }
                case 114: {
                    return node != node2.getFirstChild().getNext();
                }
                case 110: 
                case 111: 
                case 120: 
                case 126: {
                    return node != node2.getFirstChild();
                }
                case 105: {
                    return node == node2.getFirstChild().getNext().getNext();
                }
                case 4: 
                case 49: 
                case 116: 
                case 117: 
                case 118: 
                case 130: {
                    return false;
                }
                case 77: {
                    if (node != node2.getFirstChild().getNext()) break;
                    Preconditions.checkState((this.exceptionHandler.peek() == node2 ? 1 : 0) != 0);
                    this.exceptionHandler.pop();
                }
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 108: {
                this.handleIf(node);
                return;
            }
            case 113: {
                this.handleWhile(node);
                return;
            }
            case 114: {
                this.handleDo(node);
                return;
            }
            case 115: {
                this.handleFor(node);
                return;
            }
            case 110: {
                this.handleSwitch(node);
                return;
            }
            case 111: {
                this.handleCase(node);
                return;
            }
            case 112: {
                this.handleDefault(node);
                return;
            }
            case 125: 
            case 132: {
                this.handleStmtList(node);
                return;
            }
            case 105: {
                this.handleFunction(node);
                return;
            }
            case 130: {
                this.handleExpr(node);
                return;
            }
            case 49: {
                this.handleThrow(node);
                return;
            }
            case 77: {
                this.handleTry(node);
                return;
            }
            case 120: {
                this.handleCatch(node);
                return;
            }
            case 116: {
                this.handleBreak(node);
                return;
            }
            case 117: {
                this.handleContinue(node);
                return;
            }
            case 4: {
                this.handleReturn(node);
                return;
            }
            case 119: {
                this.handleWith(node);
                return;
            }
            case 126: {
                return;
            }
        }
        this.handleStmt(node);
    }

    private void handleIf(Node node) {
        Node node2 = node.getFirstChild().getNext();
        Node node3 = node2.getNext();
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node2));
        if (node3 == null) {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFallThrough(node3));
        }
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleWhile(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node.getFirstChild().getNext()));
        this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleDo(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node.getFirstChild()));
        this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, NodeUtil.getConditionExpression(node));
    }

    private void handleFor(Node node) {
        if (node.getChildCount() == 4) {
            Node node2 = node.getFirstChild();
            Node node3 = node2.getNext();
            Node node4 = node3.getNext();
            Node node5 = node4.getNext();
            this.createEdge(node2, ControlFlowGraph.Branch.UNCOND, node);
            this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node5));
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
            this.createEdge(node4, ControlFlowGraph.Branch.UNCOND, node);
            this.connectToPossibleExceptionHandler(node2, node2);
            this.connectToPossibleExceptionHandler(node, node3);
            this.connectToPossibleExceptionHandler(node4, node4);
        } else {
            Node node6 = node.getFirstChild();
            Node node7 = node6.getNext();
            Node node8 = node7.getNext();
            this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, ControlFlowAnalysis.computeFallThrough(node8));
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
            this.connectToPossibleExceptionHandler(node, node7);
        }
    }

    private void handleSwitch(Node node) {
        Node node2 = ControlFlowAnalysis.getNextSiblingOfType(node.getFirstChild().getNext(), 111, 124);
        if (node2 != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node2);
        } else if (node.getFirstChild().getNext() != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild().getNext());
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleCase(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.ON_TRUE, node.getFirstChild().getNext());
        Node node2 = ControlFlowAnalysis.getNextSiblingOfType(node.getNext(), 111);
        if (node2 != null) {
            Preconditions.checkState((node2.getType() == 111 ? 1 : 0) != 0);
            this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, node2);
        } else {
            Node node3 = node.getParent();
            Node node4 = ControlFlowAnalysis.getNextSiblingOfType(node3.getFirstChild().getNext(), 112);
            if (node4 != null) {
                this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, node4);
            } else {
                this.createEdge(node, ControlFlowGraph.Branch.ON_FALSE, ControlFlowAnalysis.computeFollowNode(node, this));
            }
        }
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleDefault(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild());
    }

    private void handleWith(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getLastChild());
        this.connectToPossibleExceptionHandler(node, node.getFirstChild());
    }

    private void handleStmtList(Node node) {
        Node node2;
        Node node3 = node.getParent();
        if (node.getType() == 125 && node3 != null && node3.getType() == 77 && NodeUtil.getCatchBlock(node3) == node && !NodeUtil.hasCatchHandler(node)) {
            return;
        }
        for (node2 = node.getFirstChild(); node2 != null && node2.getType() == 105; node2 = node2.getNext()) {
        }
        if (node2 != null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(node2));
        } else {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        }
        if (node3 != null) {
            switch (node3.getType()) {
                case 77: 
                case 111: 
                case 112: {
                    break;
                }
                default: {
                    if (node.getType() != 125 || !node.isSyntheticBlock()) break;
                    this.createEdge(node, ControlFlowGraph.Branch.SYN_BLOCK, ControlFlowAnalysis.computeFollowNode(node, this));
                }
            }
        }
    }

    private void handleFunction(Node node) {
        Preconditions.checkState((node.getChildCount() >= 3 ? 1 : 0) != 0);
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(node.getFirstChild().getNext().getNext()));
        Preconditions.checkState((this.exceptionHandler.peek() == node ? 1 : 0) != 0);
        this.exceptionHandler.pop();
    }

    private void handleExpr(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, node);
    }

    private void handleThrow(Node node) {
        this.connectToPossibleExceptionHandler(node, node);
    }

    private void handleTry(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getFirstChild());
    }

    private void handleCatch(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node.getLastChild());
    }

    private void handleBreak(Node node) {
        String string = null;
        if (node.hasChildren()) {
            string = node.getFirstChild().getString();
        }
        Node node2 = node.getParent();
        Node node3 = node;
        Node node4 = node;
        while (!ControlFlowAnalysis.isBreakTarget(node3, string)) {
            if (node3.getType() == 77 && NodeUtil.hasFinally(node3)) {
                if (node4 == node) {
                    this.createEdge(node4, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFallThrough(node3.getLastChild()));
                } else {
                    this.finallyMap.put((Object)node4, (Object)ControlFlowAnalysis.computeFallThrough(node3.getLastChild()));
                }
                node4 = node3;
            }
            Preconditions.checkState((node2 != null ? 1 : 0) != 0, (Object)"Cannot find break target.");
            node3 = node2;
            node2 = node2.getParent();
        }
        if (node4 == node) {
            this.createEdge(node4, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node3, this));
        } else {
            this.finallyMap.put((Object)node4, (Object)ControlFlowAnalysis.computeFollowNode(node3, this));
        }
    }

    private void handleContinue(Node node) {
        String string = null;
        if (node.hasChildren()) {
            string = node.getFirstChild().getString();
        }
        Node node2 = node.getParent();
        Node node3 = node;
        Node node4 = node;
        while (!ControlFlowAnalysis.isContinueTarget(node3, node2, string)) {
            if (node3.getType() == 77 && NodeUtil.hasFinally(node3)) {
                if (node4 == node) {
                    this.createEdge(node4, ControlFlowGraph.Branch.UNCOND, node3.getLastChild());
                } else {
                    this.finallyMap.put((Object)node4, (Object)ControlFlowAnalysis.computeFallThrough(node3.getLastChild()));
                }
                node4 = node3;
            }
            Preconditions.checkState((node2 != null ? 1 : 0) != 0, (Object)"Cannot find continue target.");
            node3 = node2;
            node2 = node2.getParent();
        }
        Node node5 = node3;
        if (node3.getChildCount() == 4) {
            node5 = node3.getFirstChild().getNext().getNext();
        }
        if (node4 == node) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node5);
        } else {
            this.finallyMap.put((Object)node4, (Object)node5);
        }
    }

    private void handleReturn(Node node) {
        Node node2 = null;
        for (Node node3 : this.exceptionHandler) {
            if (NodeUtil.isFunction(node3)) break;
            if (!NodeUtil.hasFinally(node3)) continue;
            if (node2 == null) {
                this.createEdge(node, ControlFlowGraph.Branch.UNCOND, node3.getLastChild());
            } else {
                this.finallyMap.put(node2, (Object)ControlFlowAnalysis.computeFallThrough(node3.getLastChild()));
            }
            node2 = node3;
        }
        if (node.hasChildren()) {
            this.connectToPossibleExceptionHandler(node, node.getFirstChild());
        }
        if (node2 == null) {
            this.createEdge(node, ControlFlowGraph.Branch.UNCOND, null);
        } else {
            this.finallyMap.put(node2, null);
        }
    }

    private void handleStmt(Node node) {
        this.createEdge(node, ControlFlowGraph.Branch.UNCOND, ControlFlowAnalysis.computeFollowNode(node, this));
        this.connectToPossibleExceptionHandler(node, node);
    }

    static Node computeFollowNode(Node node, ControlFlowAnalysis controlFlowAnalysis) {
        return ControlFlowAnalysis.computeFollowNode(node, node, controlFlowAnalysis);
    }

    static Node computeFollowNode(Node node) {
        return ControlFlowAnalysis.computeFollowNode(node, node, null);
    }

    private static Node computeFollowNode(Node node, Node node2, ControlFlowAnalysis controlFlowAnalysis) {
        Node node3;
        Node node4 = node2.getParent();
        if (node4 == null || node4.getType() == 105 || controlFlowAnalysis != null && node2 == controlFlowAnalysis.root) {
            return null;
        }
        switch (node4.getType()) {
            case 108: {
                return ControlFlowAnalysis.computeFollowNode(node, node4, controlFlowAnalysis);
            }
            case 111: 
            case 112: {
                if (node4.getNext() != null) {
                    if (node4.getNext().getType() == 111) {
                        return node4.getNext().getFirstChild().getNext();
                    }
                    if (node4.getNext().getType() == 112) {
                        return node4.getNext().getFirstChild();
                    }
                    Preconditions.checkState((boolean)false, (Object)"Not reachable");
                    break;
                }
                return ControlFlowAnalysis.computeFollowNode(node, node4, controlFlowAnalysis);
            }
            case 115: {
                if (NodeUtil.isForIn(node4)) {
                    return node4;
                }
                return node4.getFirstChild().getNext().getNext();
            }
            case 113: 
            case 114: {
                return node4;
            }
            case 77: {
                if (node4.getFirstChild() == node2) {
                    if (NodeUtil.hasFinally(node4)) {
                        return ControlFlowAnalysis.computeFallThrough(node4.getLastChild());
                    }
                    return ControlFlowAnalysis.computeFollowNode(node, node4, controlFlowAnalysis);
                }
                if (NodeUtil.getCatchBlock(node4) == node2) {
                    if (NodeUtil.hasFinally(node4)) {
                        return ControlFlowAnalysis.computeFallThrough(node2.getNext());
                    }
                    return ControlFlowAnalysis.computeFollowNode(node, node4, controlFlowAnalysis);
                }
                if (node4.getLastChild() != node2) break;
                if (controlFlowAnalysis != null) {
                    for (Node node5 : controlFlowAnalysis.finallyMap.get((Object)node4)) {
                        controlFlowAnalysis.createEdge(node, ControlFlowGraph.Branch.UNCOND, node5);
                    }
                }
                return ControlFlowAnalysis.computeFollowNode(node, node4, controlFlowAnalysis);
            }
        }
        for (node3 = node2.getNext(); node3 != null && node3.getType() == 105; node3 = node3.getNext()) {
        }
        if (node3 != null) {
            return ControlFlowAnalysis.computeFallThrough(node3);
        }
        return ControlFlowAnalysis.computeFollowNode(node, node4, controlFlowAnalysis);
    }

    static Node computeFallThrough(Node node) {
        switch (node.getType()) {
            case 114: {
                return ControlFlowAnalysis.computeFallThrough(node.getFirstChild());
            }
            case 115: {
                if (NodeUtil.isForIn(node)) {
                    return node;
                }
                return ControlFlowAnalysis.computeFallThrough(node.getFirstChild());
            }
            case 126: {
                return ControlFlowAnalysis.computeFallThrough(node.getLastChild());
            }
        }
        return node;
    }

    private void createEdge(Node node, ControlFlowGraph.Branch branch, Node node2) {
        this.cfg.createNode(node);
        this.cfg.createNode(node2);
        this.cfg.connectIfNotFound(node, branch, node2);
    }

    private void connectToPossibleExceptionHandler(Node node, Node node2) {
        if (ControlFlowAnalysis.mayThrowException(node2) && !this.exceptionHandler.isEmpty()) {
            Node node3 = node;
            for (Node node4 : this.exceptionHandler) {
                if (NodeUtil.isFunction(node4)) {
                    return;
                }
                Preconditions.checkState((node4.getType() == 77 ? 1 : 0) != 0);
                Node node5 = NodeUtil.getCatchBlock(node4);
                if (!NodeUtil.hasCatchHandler(node5)) {
                    if (node3 == node) {
                        this.createEdge(node, ControlFlowGraph.Branch.ON_EX, node4.getLastChild());
                    } else {
                        this.finallyMap.put((Object)node3, (Object)node4.getLastChild());
                    }
                } else {
                    if (node3 == node) {
                        this.createEdge(node, ControlFlowGraph.Branch.ON_EX, node5);
                        return;
                    }
                    this.finallyMap.put((Object)node3, (Object)node5);
                }
                node3 = node4;
            }
        }
    }

    private static Node getNextSiblingOfType(Node node, int ... nArray) {
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            for (int n : nArray) {
                if (node2.getType() != n) continue;
                return node2;
            }
        }
        return null;
    }

    public static boolean isBreakTarget(Node node, String string) {
        return ControlFlowAnalysis.isBreakStructure(node, string != null) && ControlFlowAnalysis.matchLabel(node.getParent(), string);
    }

    private static boolean isContinueTarget(Node node, Node node2, String string) {
        return ControlFlowAnalysis.isContinueStructure(node) && ControlFlowAnalysis.matchLabel(node2, string);
    }

    private static boolean matchLabel(Node node, String string) {
        if (string == null) {
            return true;
        }
        while (node.getType() == 126) {
            if (node.getFirstChild().getString().equals(string)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static boolean mayThrowException(Node node) {
        switch (node.getType()) {
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 49: 
            case 52: 
            case 86: 
            case 102: 
            case 103: {
                return true;
            }
            case 105: {
                return false;
            }
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (ControlFlowGraph.isEnteringNewCfgNode(node2) || !ControlFlowAnalysis.mayThrowException(node2)) continue;
            return true;
        }
        return false;
    }

    static boolean isBreakStructure(Node node, boolean bl) {
        switch (node.getType()) {
            case 110: 
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
            case 77: 
            case 108: 
            case 125: {
                return bl;
            }
        }
        return false;
    }

    static boolean isContinueStructure(Node node) {
        switch (node.getType()) {
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    static Node getExceptionHandler(Node node) {
        Node node2 = node;
        while (node2.getType() != 132 && node2.getType() != 105) {
            Node node3 = ControlFlowAnalysis.getCatchHandlerForBlock(node2);
            if (node3 != null) {
                return node3;
            }
            node2 = node2.getParent();
        }
        return null;
    }

    static Node getCatchHandlerForBlock(Node node) {
        if (node.getType() == 125 && node.getParent().getType() == 77 && node.getParent().getFirstChild() == node) {
            for (Node node2 = node.getNext(); node2 != null; node2 = node2.getNext()) {
                if (!NodeUtil.hasCatchHandler(node2)) continue;
                return node2.getFirstChild();
            }
        }
        return null;
    }

    private static class AstControlFlowGraph
    extends ControlFlowGraph<Node> {
        private final Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> priorities;

        private AstControlFlowGraph(Node node, Map<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>, Integer> map, boolean bl) {
            super(node, true, bl);
            this.priorities = map;
        }

        @Override
        public Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> getOptionalNodeComparator(boolean bl) {
            if (bl) {
                return new Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

                    @Override
                    public int compare(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode, DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode2) {
                        return AstControlFlowGraph.this.getPosition(diGraphNode) - AstControlFlowGraph.this.getPosition(diGraphNode2);
                    }
                };
            }
            return new Comparator<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>(){

                @Override
                public int compare(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode, DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode2) {
                    return AstControlFlowGraph.this.getPosition(diGraphNode2) - AstControlFlowGraph.this.getPosition(diGraphNode);
                }
            };
        }

        private int getPosition(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> diGraphNode) {
            Integer n = this.priorities.get(diGraphNode);
            Preconditions.checkNotNull((Object)n);
            return n;
        }
    }
}

