/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.VariableRenamingPolicy;

public enum CompilationLevel {
    WHITESPACE_ONLY,
    SIMPLE_OPTIMIZATIONS,
    ADVANCED_OPTIMIZATIONS;


    public void setOptionsForCompilationLevel(CompilerOptions compilerOptions) {
        switch (this) {
            case WHITESPACE_ONLY: {
                CompilationLevel.applyBasicCompilationOptions(compilerOptions);
                break;
            }
            case SIMPLE_OPTIMIZATIONS: {
                CompilationLevel.applySafeCompilationOptions(compilerOptions);
                break;
            }
            case ADVANCED_OPTIMIZATIONS: {
                CompilationLevel.applyFullCompilationOptions(compilerOptions);
                break;
            }
            default: {
                throw new RuntimeException("Unknown compilation level.");
            }
        }
    }

    public void setDebugOptionsForCompilationLevel(CompilerOptions compilerOptions) {
        compilerOptions.anonymousFunctionNaming = AnonymousFunctionNamingPolicy.UNMAPPED;
        compilerOptions.generatePseudoNames = true;
        compilerOptions.removeClosureAsserts = false;
    }

    private static void applyBasicCompilationOptions(CompilerOptions compilerOptions) {
        compilerOptions.skipAllCompilerPasses();
        compilerOptions.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
    }

    private static void applySafeCompilationOptions(CompilerOptions compilerOptions) {
        compilerOptions.closurePass = true;
        compilerOptions.variableRenaming = VariableRenamingPolicy.LOCAL;
        compilerOptions.inlineLocalVariables = true;
        compilerOptions.flowSensitiveInlineVariables = true;
        compilerOptions.inlineLocalFunctions = true;
        compilerOptions.checkGlobalThisLevel = CheckLevel.OFF;
        compilerOptions.foldConstants = true;
        compilerOptions.coalesceVariableNames = true;
        compilerOptions.deadAssignmentElimination = true;
        compilerOptions.collapseVariableDeclarations = true;
        compilerOptions.convertToDottedProperties = true;
        compilerOptions.labelRenaming = true;
        compilerOptions.removeDeadCode = true;
        compilerOptions.optimizeArgumentsArray = true;
        compilerOptions.removeUnusedVars = false;
        compilerOptions.removeUnusedLocalVars = true;
        compilerOptions.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
    }

    private static void applyFullCompilationOptions(CompilerOptions compilerOptions) {
        compilerOptions.closurePass = true;
        compilerOptions.foldConstants = true;
        compilerOptions.coalesceVariableNames = true;
        compilerOptions.deadAssignmentElimination = true;
        compilerOptions.extractPrototypeMemberDeclarations = true;
        compilerOptions.collapseVariableDeclarations = true;
        compilerOptions.convertToDottedProperties = true;
        compilerOptions.rewriteFunctionExpressions = true;
        compilerOptions.labelRenaming = true;
        compilerOptions.removeDeadCode = true;
        compilerOptions.optimizeArgumentsArray = true;
        compilerOptions.removeClosureAsserts = true;
        compilerOptions.aliasKeywords = true;
        compilerOptions.reserveRawExports = true;
        compilerOptions.variableRenaming = VariableRenamingPolicy.ALL;
        compilerOptions.propertyRenaming = PropertyRenamingPolicy.ALL_UNQUOTED;
        compilerOptions.removeUnusedPrototypeProperties = true;
        compilerOptions.removeUnusedPrototypePropertiesInExterns = true;
        compilerOptions.collapseAnonymousFunctions = true;
        compilerOptions.collapseProperties = true;
        compilerOptions.checkGlobalThisLevel = CheckLevel.WARNING;
        compilerOptions.rewriteFunctionExpressions = true;
        compilerOptions.smartNameRemoval = true;
        compilerOptions.inlineConstantVars = true;
        compilerOptions.inlineFunctions = true;
        compilerOptions.inlineLocalFunctions = true;
        compilerOptions.inlineGetters = true;
        compilerOptions.inlineVariables = true;
        compilerOptions.flowSensitiveInlineVariables = true;
        compilerOptions.computeFunctionSideEffects = true;
        compilerOptions.removeUnusedVars = true;
        compilerOptions.removeUnusedLocalVars = true;
        compilerOptions.crossModuleCodeMotion = true;
        compilerOptions.crossModuleMethodMotion = true;
        compilerOptions.devirtualizePrototypeMethods = true;
        compilerOptions.optimizeParameters = true;
        compilerOptions.optimizeReturns = true;
        compilerOptions.optimizeCalls = true;
        compilerOptions.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.WARNING);
    }
}

