/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Map;

class ClosureReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private final Visitor<JSType> restrictToArrayVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType jSType) {
            return jSType;
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            JSType jSType = ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE);
            return jSType.isSubtype(objectType) ? jSType : null;
        }
    };
    private final Visitor<JSType> restrictToNotArrayVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(){

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return objectType.isSubtype(ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE)) ? null : objectType;
        }
    };
    private final Visitor<JSType> restrictToObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType jSType) {
            return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return objectType;
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return functionType;
        }
    };
    private final Visitor<JSType> restrictToNotObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(){

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return null;
        }
    };
    private Map<String, Function<TypeRestriction, JSType>> restricters = new ImmutableMap.Builder().put((Object)"isDef", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            if (typeRestriction.outcome) {
                return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(typeRestriction.type);
            }
            return null;
        }
    }).put((Object)"isNull", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            if (typeRestriction.outcome) {
                return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
            }
            return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutNull(typeRestriction.type);
        }
    }).put((Object)"isDefAndNotNull", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            if (typeRestriction.outcome) {
                return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(ClosureReverseAbstractInterpreter.this.getRestrictedWithoutNull(typeRestriction.type));
            }
            return null;
        }
    }).put((Object)"isString", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(typeRestriction.type, "string", typeRestriction.outcome);
        }
    }).put((Object)"isBoolean", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(typeRestriction.type, "boolean", typeRestriction.outcome);
        }
    }).put((Object)"isNumber", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(typeRestriction.type, "number", typeRestriction.outcome);
        }
    }).put((Object)"isFunction", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(typeRestriction.type, "function", typeRestriction.outcome);
        }
    }).put((Object)"isArray", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            if (typeRestriction.type == null) {
                return typeRestriction.outcome ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE) : null;
            }
            Visitor visitor = typeRestriction.outcome ? ClosureReverseAbstractInterpreter.this.restrictToArrayVisitor : ClosureReverseAbstractInterpreter.this.restrictToNotArrayVisitor;
            return (JSType)typeRestriction.type.visit(visitor);
        }
    }).put((Object)"isObject", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction typeRestriction) {
            if (typeRestriction.type == null) {
                return typeRestriction.outcome ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.OBJECT_TYPE) : null;
            }
            Visitor visitor = typeRestriction.outcome ? ClosureReverseAbstractInterpreter.this.restrictToObjectVisitor : ClosureReverseAbstractInterpreter.this.restrictToNotObjectVisitor;
            return (JSType)typeRestriction.type.visit(visitor);
        }
    }).build();

    ClosureReverseAbstractInterpreter(CodingConvention codingConvention, JSTypeRegistry jSTypeRegistry) {
        super(codingConvention, jSTypeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node node, FlowScope flowScope, boolean bl) {
        if (node.getType() == 37 && node.getChildCount() == 2) {
            Node node2 = node.getFirstChild();
            Node node3 = node.getLastChild();
            if (node2.getType() == 33 && node3.isQualifiedName()) {
                Function<TypeRestriction, JSType> function;
                JSType jSType = this.getTypeIfRefinable(node3, flowScope);
                Node node4 = node2.getFirstChild();
                Node node5 = node2.getLastChild();
                if (node4.getType() == 38 && "goog".equals(node4.getString()) && node5.getType() == 40 && (function = this.restricters.get(node5.getString())) != null) {
                    return this.restrictParameter(node3, jSType, flowScope, function, bl);
                }
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(node, flowScope, bl);
    }

    private FlowScope restrictParameter(Node node, JSType jSType, FlowScope flowScope, Function<TypeRestriction, JSType> function, boolean bl) {
        if ((jSType = (JSType)function.apply((Object)new TypeRestriction(jSType, bl))) != null) {
            FlowScope flowScope2 = flowScope.createChildFlowScope();
            this.declareNameInScope(flowScope2, node, jSType);
            return flowScope2;
        }
        return flowScope;
    }

    private static class TypeRestriction {
        private final JSType type;
        private final boolean outcome;

        private TypeRestriction(JSType jSType, boolean bl) {
            this.type = jSType;
            this.outcome = bl;
        }
    }
}

