/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor9;

public class TypeSignature {
    Elements elems;
    private static final String SIG_VOID = "V";
    private static final String SIG_BOOLEAN = "Z";
    private static final String SIG_BYTE = "B";
    private static final String SIG_CHAR = "C";
    private static final String SIG_SHORT = "S";
    private static final String SIG_INT = "I";
    private static final String SIG_LONG = "J";
    private static final String SIG_FLOAT = "F";
    private static final String SIG_DOUBLE = "D";
    private static final String SIG_ARRAY = "[";
    private static final String SIG_CLASS = "L";

    public TypeSignature(Elements elems) {
        this.elems = elems;
    }

    public String getTypeSignature(String javasignature) throws SignatureException {
        return this.getParamJVMSignature(javasignature);
    }

    public String getTypeSignature(String javasignature, TypeMirror returnType) throws SignatureException {
        String signature = null;
        String typeSignature = null;
        ArrayList<String> params = new ArrayList<String>();
        String paramsig = null;
        String paramJVMSig = null;
        String returnSig = null;
        String returnJVMType = null;
        int dimensions = 0;
        int startIndex = -1;
        int endIndex = -1;
        StringTokenizer st = null;
        int i = 0;
        if (javasignature != null) {
            startIndex = javasignature.indexOf("(");
            endIndex = javasignature.indexOf(")");
        }
        if (startIndex != -1 && endIndex != -1 && startIndex + 1 < javasignature.length() && endIndex < javasignature.length()) {
            signature = javasignature.substring(startIndex + 1, endIndex);
        }
        if (signature != null) {
            if (signature.contains(",")) {
                st = new StringTokenizer(signature, ",");
                if (st != null) {
                    while (st.hasMoreTokens()) {
                        params.add(st.nextToken());
                    }
                }
            } else {
                params.add(signature);
            }
        }
        typeSignature = "(";
        while (!params.isEmpty()) {
            paramsig = ((String)params.remove(i)).trim();
            paramJVMSig = this.getParamJVMSignature(paramsig);
            if (paramJVMSig == null) continue;
            typeSignature = typeSignature + paramJVMSig;
        }
        typeSignature = typeSignature + ")";
        returnJVMType = "";
        if (returnType != null) {
            dimensions = this.dimensions(returnType);
        }
        while (dimensions-- > 0) {
            returnJVMType = returnJVMType + SIG_ARRAY;
        }
        if (returnType != null) {
            returnSig = this.qualifiedTypeName(returnType);
            returnJVMType = returnJVMType + this.getComponentType(returnSig);
        } else {
            System.out.println("Invalid return type.");
        }
        typeSignature = typeSignature + returnJVMType;
        return typeSignature;
    }

    private String getParamJVMSignature(String paramsig) throws SignatureException {
        String paramJVMSig = "";
        String componentType = "";
        if (paramsig != null) {
            if (paramsig.contains("[]")) {
                int endindex = paramsig.indexOf("[]");
                componentType = paramsig.substring(0, endindex);
                String dimensionString = paramsig.substring(endindex);
                if (dimensionString != null) {
                    while (dimensionString.contains("[]")) {
                        paramJVMSig = paramJVMSig + SIG_ARRAY;
                        int beginindex = dimensionString.indexOf("]") + 1;
                        if (beginindex < dimensionString.length()) {
                            dimensionString = dimensionString.substring(beginindex);
                            continue;
                        }
                        dimensionString = "";
                    }
                }
            } else {
                componentType = paramsig;
            }
            paramJVMSig = paramJVMSig + this.getComponentType(componentType);
        }
        return paramJVMSig;
    }

    private String getComponentType(String componentType) throws SignatureException {
        String JVMSig = "";
        if (componentType != null) {
            switch (componentType) {
                case "void": {
                    JVMSig = JVMSig + SIG_VOID;
                    break;
                }
                case "boolean": {
                    JVMSig = JVMSig + SIG_BOOLEAN;
                    break;
                }
                case "byte": {
                    JVMSig = JVMSig + SIG_BYTE;
                    break;
                }
                case "char": {
                    JVMSig = JVMSig + SIG_CHAR;
                    break;
                }
                case "short": {
                    JVMSig = JVMSig + SIG_SHORT;
                    break;
                }
                case "int": {
                    JVMSig = JVMSig + SIG_INT;
                    break;
                }
                case "long": {
                    JVMSig = JVMSig + SIG_LONG;
                    break;
                }
                case "float": {
                    JVMSig = JVMSig + SIG_FLOAT;
                    break;
                }
                case "double": {
                    JVMSig = JVMSig + SIG_DOUBLE;
                    break;
                }
                default: {
                    if (componentType.equals("")) break;
                    TypeElement classNameDoc = this.elems.getTypeElement(componentType);
                    if (classNameDoc == null) {
                        throw new SignatureException(componentType);
                    }
                    String classname = classNameDoc.getQualifiedName().toString();
                    String newclassname = classname.replace('.', '/');
                    JVMSig = JVMSig + SIG_CLASS;
                    JVMSig = JVMSig + newclassname;
                    JVMSig = JVMSig + ";";
                }
            }
        }
        return JVMSig;
    }

    int dimensions(TypeMirror t) {
        if (t.getKind() != TypeKind.ARRAY) {
            return 0;
        }
        return 1 + this.dimensions(((ArrayType)t).getComponentType());
    }

    String qualifiedTypeName(TypeMirror type) {
        SimpleTypeVisitor9<Name, Void> v = new SimpleTypeVisitor9<Name, Void>(){

            @Override
            public Name visitArray(ArrayType t, Void p) {
                return t.getComponentType().accept(this, p);
            }

            @Override
            public Name visitDeclared(DeclaredType t, Void p) {
                return ((TypeElement)t.asElement()).getQualifiedName();
            }

            @Override
            public Name visitPrimitive(PrimitiveType t, Void p) {
                return TypeSignature.this.elems.getName(t.toString());
            }

            @Override
            public Name visitNoType(NoType t, Void p) {
                if (t.getKind() == TypeKind.VOID) {
                    return TypeSignature.this.elems.getName("void");
                }
                return (Name)this.defaultAction(t, p);
            }

            @Override
            public Name visitTypeVariable(TypeVariable t, Void p) {
                return t.getUpperBound().accept(this, p);
            }
        };
        return ((Name)v.visit(type)).toString();
    }

    static class SignatureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        SignatureException(String reason) {
            super(reason);
        }
    }
}

