/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.tools.javac.util.Convert;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class DocPretty
implements DocTreeVisitor<Void, Void> {
    final Writer out;
    int lmargin = 0;
    final String lineSep = System.getProperty("line.separator");

    public DocPretty(Writer out) {
        this.out = out;
    }

    public void print(DocTree tree) throws IOException {
        try {
            if (tree == null) {
                this.print("/*missing*/");
            } else {
                tree.accept(this, null);
            }
        }
        catch (UncheckedIOException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    protected void print(Object s) throws IOException {
        this.out.write(Convert.escapeUnicode(s.toString()));
    }

    public void print(List<? extends DocTree> list) throws IOException {
        for (DocTree docTree : list) {
            this.print(docTree);
        }
    }

    protected void print(List<? extends DocTree> list, String sep) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        boolean first = true;
        for (DocTree docTree : list) {
            if (!first) {
                this.print(sep);
            }
            this.print(docTree);
            first = false;
        }
    }

    protected void println() throws IOException {
        this.out.write(this.lineSep);
    }

    protected void printTagName(DocTree node) throws IOException {
        this.out.write("@");
        this.out.write(node.getKind().tagName);
    }

    @Override
    public Void visitAttribute(AttributeTree node, Void p) {
        try {
            String quote;
            this.print(node.getName());
            switch (node.getValueKind()) {
                case EMPTY: {
                    quote = null;
                    break;
                }
                case UNQUOTED: {
                    quote = "";
                    break;
                }
                case SINGLE: {
                    quote = "'";
                    break;
                }
                case DOUBLE: {
                    quote = "\"";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (quote != null) {
                String string = String.valueOf(quote);
                this.print(string.length() != 0 ? "=".concat(string) : new String("="));
                this.print(node.getValue());
                this.print(quote);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitAuthor(AuthorTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitComment(CommentTree node, Void p) {
        try {
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitDeprecated(DeprecatedTree node, Void p) {
        try {
            this.printTagName(node);
            if (!node.getBody().isEmpty()) {
                this.print(" ");
                this.print(node.getBody());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitDocComment(DocCommentTree node, Void p) {
        try {
            List<? extends DocTree> fs = node.getFirstSentence();
            List<? extends DocTree> b = node.getBody();
            List<? extends DocTree> t = node.getBlockTags();
            this.print(fs);
            if (!fs.isEmpty() && !b.isEmpty()) {
                this.print(" ");
            }
            this.print(b);
            if (!(fs.isEmpty() && b.isEmpty() || t.isEmpty())) {
                this.print("\n");
            }
            this.print(t, "\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitDocRoot(DocRootTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitEndElement(EndElementTree node, Void p) {
        try {
            this.print("</");
            this.print(node.getName());
            this.print(">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree node, Void p) {
        try {
            this.print("&");
            this.print(node.getName());
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree node, Void p) {
        try {
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        try {
            this.print(node.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitInheritDoc(InheritDocTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitLink(LinkTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print(" ");
            this.print(node.getReference());
            if (!node.getLabel().isEmpty()) {
                this.print(" ");
                this.print(node.getLabel());
            }
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            this.print(" ");
            this.print(node.getBody());
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitParam(ParamTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            if (node.isTypeParameter()) {
                this.print("<");
            }
            this.print(node.getName());
            if (node.isTypeParameter()) {
                this.print(">");
            }
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitReference(ReferenceTree node, Void p) {
        try {
            this.print(node.getSignature());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getDescription());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSee(SeeTree node, Void p) {
        try {
            this.printTagName(node);
            boolean first = true;
            boolean needSep = true;
            for (DocTree docTree : node.getReference()) {
                if (needSep) {
                    this.print(" ");
                }
                needSep = first && docTree instanceof ReferenceTree;
                first = false;
                this.print(docTree);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSerial(SerialTree node, Void p) {
        try {
            this.printTagName(node);
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSerialData(SerialDataTree node, Void p) {
        try {
            this.printTagName(node);
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSerialField(SerialFieldTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getName());
            this.print(" ");
            this.print(node.getType());
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitSince(SinceTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitStartElement(StartElementTree node, Void p) {
        try {
            this.print("<");
            this.print(node.getName());
            List<? extends DocTree> attrs = node.getAttributes();
            if (!attrs.isEmpty()) {
                this.print(" ");
                this.print(attrs);
                DocTree last = node.getAttributes().get(attrs.size() - 1);
                if (node.isSelfClosing() && last instanceof AttributeTree && ((AttributeTree)last).getValueKind() == AttributeTree.ValueKind.UNQUOTED) {
                    this.print(" ");
                }
            }
            if (node.isSelfClosing()) {
                this.print("/");
            }
            this.print(">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitText(TextTree node, Void p) {
        try {
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitThrows(ThrowsTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getExceptionName());
            if (!node.getDescription().isEmpty()) {
                this.print(" ");
                this.print(node.getDescription());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
        try {
            this.print("@");
            this.print(node.getTagName());
            this.print(" ");
            this.print(node.getContent());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree node, Void p) {
        try {
            this.print("{");
            this.print("@");
            this.print(node.getTagName());
            this.print(" ");
            this.print(node.getContent());
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitValue(ValueTree node, Void p) {
        try {
            this.print("{");
            this.printTagName(node);
            if (node.getReference() != null) {
                this.print(" ");
                this.print(node.getReference());
            }
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitVersion(VersionTree node, Void p) {
        try {
            this.printTagName(node);
            this.print(" ");
            this.print(node.getBody());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public Void visitOther(DocTree node, Void p) {
        try {
            String string = String.valueOf(String.valueOf(node));
            this.print(new StringBuilder(11 + string.length()).append("(UNKNOWN: ").append(string).append(")").toString());
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    private static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        UncheckedIOException(IOException e) {
            super(e.getMessage(), e);
        }
    }
}

