/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.util;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldCache;
import com.google.appengine.repackaged.org.apache.lucene.util.MapOfSets;
import com.google.appengine.repackaged.org.apache.lucene.util.RamUsageEstimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FieldCacheSanityChecker {
    private RamUsageEstimator ramCalc = null;

    public void setRamUsageEstimator(RamUsageEstimator r) {
        this.ramCalc = r;
    }

    public static Insanity[] checkSanity(FieldCache cache) {
        return FieldCacheSanityChecker.checkSanity(cache.getCacheEntries());
    }

    public static Insanity[] checkSanity(FieldCache.CacheEntry[] cacheEntries) {
        FieldCacheSanityChecker sanityChecker = new FieldCacheSanityChecker();
        sanityChecker.setRamUsageEstimator(new RamUsageEstimator(false));
        return sanityChecker.check(cacheEntries);
    }

    public Insanity[] check(FieldCache.CacheEntry[] cacheEntries) {
        if (null == cacheEntries || 0 == cacheEntries.length) {
            return new Insanity[0];
        }
        if (null != this.ramCalc) {
            for (int i = 0; i < cacheEntries.length; ++i) {
                cacheEntries[i].estimateSize(this.ramCalc);
            }
        }
        MapOfSets valIdToItems = new MapOfSets(new HashMap(17));
        MapOfSets readerFieldToValIds = new MapOfSets(new HashMap(17));
        HashSet<ReaderField> valMismatchKeys = new HashSet<ReaderField>();
        for (int i = 0; i < cacheEntries.length; ++i) {
            FieldCache.CacheEntry item = cacheEntries[i];
            Object val = item.getValue();
            if (val instanceof FieldCache.CreationPlaceholder) continue;
            ReaderField rf = new ReaderField(item.getReaderKey(), item.getFieldName());
            Integer valId = new Integer(System.identityHashCode(val));
            valIdToItems.put(valId, item);
            if (1 >= readerFieldToValIds.put(rf, valId)) continue;
            valMismatchKeys.add(rf);
        }
        ArrayList insanity = new ArrayList(valMismatchKeys.size() * 3);
        insanity.addAll(this.checkValueMismatch(valIdToItems, readerFieldToValIds, valMismatchKeys));
        insanity.addAll(this.checkSubreaders(valIdToItems, readerFieldToValIds));
        return insanity.toArray(new Insanity[insanity.size()]);
    }

    private Collection checkValueMismatch(MapOfSets valIdToItems, MapOfSets readerFieldToValIds, Set valMismatchKeys) {
        ArrayList<Insanity> insanity = new ArrayList<Insanity>(valMismatchKeys.size() * 3);
        if (!valMismatchKeys.isEmpty()) {
            Map rfMap = readerFieldToValIds.getMap();
            Map valMap = valIdToItems.getMap();
            Iterator mismatchIter = valMismatchKeys.iterator();
            while (mismatchIter.hasNext()) {
                ReaderField rf = (ReaderField)mismatchIter.next();
                ArrayList badEntries = new ArrayList(valMismatchKeys.size() * 2);
                Iterator valIter = ((Set)rfMap.get(rf)).iterator();
                while (valIter.hasNext()) {
                    Iterator entriesIter = ((Set)valMap.get(valIter.next())).iterator();
                    while (entriesIter.hasNext()) {
                        badEntries.add(entriesIter.next());
                    }
                }
                FieldCache.CacheEntry[] badness = new FieldCache.CacheEntry[badEntries.size()];
                badness = badEntries.toArray(badness);
                insanity.add(new Insanity(InsanityType.VALUEMISMATCH, "Multiple distinct value objects for " + rf.toString(), badness));
            }
        }
        return insanity;
    }

    private Collection checkSubreaders(MapOfSets valIdToItems, MapOfSets readerFieldToValIds) {
        ArrayList<Insanity> insanity = new ArrayList<Insanity>(23);
        HashMap badChildren = new HashMap(17);
        MapOfSets badKids = new MapOfSets(badChildren);
        Map viToItemSets = valIdToItems.getMap();
        Map rfToValIdSets = readerFieldToValIds.getMap();
        HashSet<ReaderField> seen = new HashSet<ReaderField>(17);
        Set readerFields = rfToValIdSets.keySet();
        Iterator rfIter = readerFields.iterator();
        while (rfIter.hasNext()) {
            ReaderField rf = (ReaderField)rfIter.next();
            if (seen.contains(rf)) continue;
            List kids = this.getAllDecendentReaderKeys(rf.readerKey);
            for (int i = 0; i < kids.size(); ++i) {
                ReaderField kid = new ReaderField(kids.get(i), rf.fieldName);
                if (badChildren.containsKey(kid)) {
                    badKids.put(rf, kid);
                    badKids.putAll(rf, (Collection)badChildren.get(kid));
                    badChildren.remove(kid);
                } else if (rfToValIdSets.containsKey(kid)) {
                    badKids.put(rf, kid);
                }
                seen.add(kid);
            }
            seen.add(rf);
        }
        Iterator parentsIter = badChildren.keySet().iterator();
        while (parentsIter.hasNext()) {
            ReaderField parent = (ReaderField)parentsIter.next();
            Set kids = (Set)badChildren.get(parent);
            ArrayList badEntries = new ArrayList(kids.size() * 2);
            Iterator valIter = ((Set)rfToValIdSets.get(parent)).iterator();
            while (valIter.hasNext()) {
                badEntries.addAll((Set)viToItemSets.get(valIter.next()));
            }
            Iterator kidsIter = kids.iterator();
            while (kidsIter.hasNext()) {
                ReaderField kid = (ReaderField)kidsIter.next();
                Iterator valIter2 = ((Set)rfToValIdSets.get(kid)).iterator();
                while (valIter2.hasNext()) {
                    badEntries.addAll((Set)viToItemSets.get(valIter2.next()));
                }
            }
            FieldCache.CacheEntry[] badness = new FieldCache.CacheEntry[badEntries.size()];
            badness = badEntries.toArray(badness);
            insanity.add(new Insanity(InsanityType.SUBREADER, "Found caches for decendents of " + parent.toString(), badness));
        }
        return insanity;
    }

    private List getAllDecendentReaderKeys(Object seed) {
        ArrayList<Object> all = new ArrayList<Object>(17);
        all.add(seed);
        for (int i = 0; i < all.size(); ++i) {
            Object obj = all.get(i);
            if (!(obj instanceof IndexReader)) continue;
            IndexReader[] subs = ((IndexReader)obj).getSequentialSubReaders();
            for (int j = 0; null != subs && j < subs.length; ++j) {
                all.add(subs[j].getFieldCacheKey());
            }
        }
        return all.subList(1, all.size());
    }

    public static final class InsanityType {
        private final String label;
        public static final InsanityType SUBREADER = new InsanityType("SUBREADER");
        public static final InsanityType VALUEMISMATCH = new InsanityType("VALUEMISMATCH");
        public static final InsanityType EXPECTED = new InsanityType("EXPECTED");

        private InsanityType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static final class Insanity {
        private final InsanityType type;
        private final String msg;
        private final FieldCache.CacheEntry[] entries;

        public Insanity(InsanityType type, String msg, FieldCache.CacheEntry[] entries) {
            if (null == type) {
                throw new IllegalArgumentException("Insanity requires non-null InsanityType");
            }
            if (null == entries || 0 == entries.length) {
                throw new IllegalArgumentException("Insanity requires non-null/non-empty CacheEntry[]");
            }
            this.type = type;
            this.msg = msg;
            this.entries = entries;
        }

        public InsanityType getType() {
            return this.type;
        }

        public String getMsg() {
            return this.msg;
        }

        public FieldCache.CacheEntry[] getCacheEntries() {
            return this.entries;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getType()).append(": ");
            String m = this.getMsg();
            if (null != m) {
                buf.append(m);
            }
            buf.append('\n');
            FieldCache.CacheEntry[] ce = this.getCacheEntries();
            for (int i = 0; i < ce.length; ++i) {
                buf.append('\t').append(ce[i].toString()).append('\n');
            }
            return buf.toString();
        }
    }

    private static final class ReaderField {
        public final Object readerKey;
        public final String fieldName;

        public ReaderField(Object readerKey, String fieldName) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
        }

        public int hashCode() {
            return System.identityHashCode(this.readerKey) * this.fieldName.hashCode();
        }

        public boolean equals(Object that) {
            if (!(that instanceof ReaderField)) {
                return false;
            }
            ReaderField other = (ReaderField)that;
            return this.readerKey == other.readerKey && this.fieldName.equals(other.fieldName);
        }

        public String toString() {
            return this.readerKey.toString() + "+" + this.fieldName;
        }
    }
}

