/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.ResultSet;
import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.SimpleListResultSet;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.Wrapper;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.MetadataResponse;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DatabaseMetaData
extends Wrapper
implements java.sql.DatabaseMetaData {
    static final int DRIVER_VERSION_MAJOR = 1;
    static final int DRIVER_VERSION_MINOR = 0;
    static final String DRIVER_NAME = "Google Cloud SQL JDBC Driver";
    private final Client.JdbcDatabaseMetaDataProto metadata;
    private final Connection conn;
    private final Url url;

    DatabaseMetaData(Client.JdbcDatabaseMetaDataProto metadata, Connection conn, Url url) {
        this.metadata = metadata;
        this.conn = conn;
        this.url = url;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return this.metadata.getAllProceduresAreCallable();
    }

    @Override
    public boolean allTablesAreSelectable() {
        return this.metadata.getAllTablesAreSelectable();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return this.metadata.getAutoCommitFailureClosesAllResultSets();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return this.metadata.getDataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return this.metadata.getDataDefinitionIgnoredInTransactions();
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return this.metadata.getDeletesAreDetectedList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return this.metadata.getDoesMaxRowSizeIncludeBlobs();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_ATTRIBUTES, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_BEST_ROW_IDENTIFIER, catalog, schema, table, Integer.toString(scope), Boolean.toString(nullable));
    }

    @Override
    public String getCatalogSeparator() {
        return this.metadata.getCatalogSeparator();
    }

    @Override
    public String getCatalogTerm() {
        return this.metadata.getCatalogTerm();
    }

    @Override
    public ResultSet getCatalogs() {
        return SimpleListResultSet.newOneColumnEnumResultSet(this.metadata.getCatalogsList(), CatalogsColumns.TABLE_CAT);
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return SimpleListResultSet.emptyResultSet(ClientInfoColumns.values());
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMN_PRIVILEGES, catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMNS, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_CROSS_REFERENCE, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.metadata.getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.metadata.getDatabaseMinorVersion();
    }

    @Override
    public String getDatabaseProductName() {
        return this.metadata.getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.metadata.getDatabaseProductVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.metadata.getDefaultTransactionIsolation().getNumber();
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return String.format("%d.%d", 1, 0);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_EXPORTED_KEYS, catalog, schema, table);
    }

    @Override
    public String getExtraNameCharacters() {
        return this.metadata.getExtraNameCharacters();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTION_COLUMNS, catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTIONS, catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.metadata.getIdentifierQuoteString();
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_IMPORTED_KEYS, catalog, schema, table);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_INDEX_INFO, BoundValue.of(catalog, JdbcType.JDBC_TYPE_VARCHAR), BoundValue.of(schema, JdbcType.JDBC_TYPE_VARCHAR), BoundValue.of(table, JdbcType.JDBC_TYPE_VARCHAR), BoundValue.of(unique, JdbcType.JDBC_TYPE_BOOLEAN), BoundValue.of(approximate, JdbcType.JDBC_TYPE_BOOLEAN));
    }

    @Override
    public int getJDBCMajorVersion() {
        return this.metadata.getJdbcMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() {
        return this.metadata.getJdbcMinorVersion();
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return this.metadata.getMaxBinaryLiteralLength();
    }

    @Override
    public int getMaxCatalogNameLength() {
        return this.metadata.getMaxCatalogNameLength();
    }

    @Override
    public int getMaxCharLiteralLength() {
        return this.metadata.getMaxCharLiteralLength();
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.metadata.getMaxColumnNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return this.metadata.getMaxColumnsInGroupBy();
    }

    @Override
    public int getMaxColumnsInIndex() {
        return this.metadata.getMaxColumnsInIndex();
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return this.metadata.getMaxColumnsInOrderBy();
    }

    @Override
    public int getMaxColumnsInSelect() {
        return this.metadata.getMaxColumnsInSelect();
    }

    @Override
    public int getMaxColumnsInTable() {
        return this.metadata.getMaxColumnsInTable();
    }

    @Override
    public int getMaxConnections() {
        return this.metadata.getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() {
        return this.metadata.getMaxCursorNameLength();
    }

    @Override
    public int getMaxIndexLength() {
        return this.metadata.getMaxIndexLength();
    }

    @Override
    public int getMaxProcedureNameLength() {
        return this.metadata.getMaxProcedureNameLength();
    }

    @Override
    public int getMaxRowSize() {
        return this.metadata.getMaxRowSize();
    }

    @Override
    public int getMaxSchemaNameLength() {
        return this.metadata.getMaxSchemaNameLength();
    }

    @Override
    public int getMaxStatementLength() {
        return this.metadata.getMaxStatementLength();
    }

    @Override
    public int getMaxStatements() {
        return this.metadata.getMaxStatements();
    }

    @Override
    public int getMaxTableNameLength() {
        return this.metadata.getMaxTableNameLength();
    }

    @Override
    public int getMaxTablesInSelect() {
        return this.metadata.getMaxTablesInSelect();
    }

    @Override
    public int getMaxUserNameLength() {
        return this.metadata.getMaxUserNameLength();
    }

    @Override
    public String getNumericFunctions() {
        return this.metadata.getNumericFunctions();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PRIMARY_KEYS, catalog, schema, table);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURE_COLUMNS, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public String getProcedureTerm() {
        return this.metadata.getProcedureTerm();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURES, catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public int getResultSetHoldability() {
        return this.metadata.getResultsetHoldability().getNumber();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return DatabaseMetaData.toRowIdLifetime(this.metadata.getRowidLifetime());
    }

    public static RowIdLifetime toRowIdLifetime(Client.JdbcDatabaseMetaDataProto.RowIdLifetime lifetime) {
        switch (lifetime) {
            case ROWIDLIFETIME_ROWID_UNSUPPORTED: {
                return RowIdLifetime.ROWID_UNSUPPORTED;
            }
            case ROWIDLIFETIME_ROWID_VALID_FOREVER: {
                return RowIdLifetime.ROWID_VALID_FOREVER;
            }
            case ROWIDLIFETIME_ROWID_VALID_OTHER: {
                return RowIdLifetime.ROWID_VALID_OTHER;
            }
            case ROWIDLIFETIME_ROWID_VALID_SESSION: {
                return RowIdLifetime.ROWID_VALID_SESSION;
            }
            case ROWIDLIFETIME_ROWID_VALID_TRANSACTION: {
                return RowIdLifetime.ROWID_VALID_TRANSACTION;
            }
        }
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() {
        return this.metadata.getSqlKeywords();
    }

    @Override
    public int getSQLStateType() {
        switch (this.metadata.getSqlStateType()) {
            case SQLSTATETYPE_SQL_STATE_SQL: {
                return 2;
            }
            case SQLSTATETYPE_SQL_STATE_SQL99: {
                return 2;
            }
            case SQLSTATETYPE_SQL_STATE_XOPEN: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public String getSchemaTerm() {
        return this.metadata.getSchemaTerm();
    }

    @Override
    public ResultSet getSchemas() {
        ArrayList<List<?>> rows = Util.newArrayList();
        for (Client.JdbcDatabaseMetaDataProto.Schema schema : this.metadata.getSchemasList()) {
            rows.add(Arrays.asList(schema.getTableSchema(), schema.getTableCatalog()));
        }
        return SimpleListResultSet.newEnumResultSet(rows, SchemasColumns.values());
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SCHEMAS, catalog, schemaPattern);
    }

    @Override
    public String getSearchStringEscape() {
        return this.metadata.getSearchStringEscape();
    }

    @Override
    public String getStringFunctions() {
        return this.metadata.getStringFunctions();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TABLES, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TYPES, catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public String getSystemFunctions() {
        return this.metadata.getSystemFunctions();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLE_PRIVILEGES, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getTableTypes() {
        return SimpleListResultSet.newOneColumnEnumResultSet(this.metadata.getTableTypesList(), TableTypesColumns.TABLE_TYPE);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLES, BoundValue.of(catalog, JdbcType.JDBC_TYPE_VARCHAR), BoundValue.of(schemaPattern, JdbcType.JDBC_TYPE_VARCHAR), BoundValue.of(tableNamePattern, JdbcType.JDBC_TYPE_VARCHAR), BoundValue.of(types == null || types.length == 0 ? null : Util.join(",", Arrays.asList(types)), JdbcType.JDBC_TYPE_VARCHAR));
    }

    @Override
    public String getTimeDateFunctions() {
        return this.metadata.getTimeDateFunctions();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TYPE_INFO);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_UDTS, catalog, schemaPattern, typeNamePattern, Util.toIntegerList(types));
    }

    @Override
    public String getURL() {
        return this.conn.getUrl();
    }

    @Override
    public String getUserName() {
        return this.metadata.getUserName();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_VERSION_COLUMNS, catalog, schema, table);
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return this.metadata.getInsertsAreDetectedList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean isCatalogAtStart() {
        return this.metadata.getCatalogAtStart();
    }

    @Override
    public boolean isReadOnly() {
        return this.metadata.getReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return this.metadata.getLocatorsUpdateCopy();
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return this.metadata.getNullPlusNonNullIsNull();
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return this.metadata.getNullsAreSortedAtEnd();
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return this.metadata.getNullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return this.metadata.getNullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedLow() {
        return this.metadata.getNullsAreSortedLow();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return this.metadata.getOthersDeletesAreVisibleList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return this.metadata.getOthersInsertsAreVisibleList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return this.metadata.getOthersUpdatesAreVisibleList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return this.metadata.getOwnDeletesAreVisibleList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return this.metadata.getOwnInsertsAreVisibleList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return this.metadata.getOwnUpdatesAreVisibleList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return this.metadata.getStoresLowerCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return this.metadata.getStoresLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return this.metadata.getStoresMixedCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return this.metadata.getStoresMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return this.metadata.getStoresUpperCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return this.metadata.getStoresUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return this.metadata.getSupportsAnsi92EntryLevelSql();
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return this.metadata.getSupportsAnsi92FullSql();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return this.metadata.getSupportsAnsi92IntermediateSql();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return this.metadata.getSupportsAlterTableWithAddColumn();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return this.metadata.getSupportsAlterTableWithDropColumn();
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.metadata.getSupportsBatchUpdates();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return this.metadata.getSupportsCatalogsInDataManipulation();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return this.metadata.getSupportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return this.metadata.getSupportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return this.metadata.getSupportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return this.metadata.getSupportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean supportsColumnAliasing() {
        return this.metadata.getSupportsColumnAliasing();
    }

    @Override
    public boolean supportsConvert() {
        return this.metadata.getSupportsConvert();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (!this.supportsConvert()) {
            return false;
        }
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return this.metadata.getSupportsCoreSqlGrammar();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return this.metadata.getSupportsCorrelatedSubqueries();
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return this.metadata.getSupportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return this.metadata.getSupportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return this.metadata.getSupportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return this.metadata.getSupportsExpressionsInOrderBy();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return this.metadata.getSupportsExtendedSqlGrammar();
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return this.metadata.getSupportsFullOuterJoins();
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return this.metadata.getSupportsGetGeneratedKeys();
    }

    @Override
    public boolean supportsGroupBy() {
        return this.metadata.getSupportsGroupBy();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return this.metadata.getSupportsGroupByBeyondSelect();
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return this.metadata.getSupportsGroupByUnrelated();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return this.metadata.getSupportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return this.metadata.getSupportsLikeEscapeClause();
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return this.metadata.getSupportsLimitedOuterJoins();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return this.metadata.getSupportsMinimumSqlGrammar();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return this.metadata.getSupportsMixedCaseIdentifiers();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return this.metadata.getSupportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return this.metadata.getSupportsMultipleOpenResults();
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return this.metadata.getSupportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return this.metadata.getSupportsMultipleTransactions();
    }

    @Override
    public boolean supportsNamedParameters() {
        return this.metadata.getSupportsNamedParameters();
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return this.metadata.getSupportsNonNullableColumns();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return this.metadata.getSupportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return this.metadata.getSupportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return this.metadata.getSupportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return this.metadata.getSupportsOpenStatementsAcrossRollback();
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return this.metadata.getSupportsOrderByUnrelated();
    }

    @Override
    public boolean supportsOuterJoins() {
        return this.metadata.getSupportsOuterJoins();
    }

    @Override
    public boolean supportsPositionedDelete() {
        return this.metadata.getSupportsPositionedDelete();
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return this.metadata.getSupportsPositionedUpdate();
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        Util.checkArgument(concurrency == 1007 || concurrency == 1008, "concurrency", concurrency);
        if (!this.supportsResultSetType(type)) {
            return false;
        }
        if (concurrency == 1007) {
            return true;
        }
        return this.metadata.getSupportsResultSetConcurrencyUpdatableList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return this.metadata.getSupportsResultSetHoldabilityList().contains(Client.ResultSetHoldability.valueOf(holdability));
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return this.metadata.getSupportsResultSetTypeList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean supportsSavepoints() {
        return this.metadata.getSupportsSavepoints();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return this.metadata.getSupportsSchemasInDataManipulation();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return this.metadata.getSupportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return this.metadata.getSupportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return this.metadata.getSupportsSchemasInProcedureCalls();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return this.metadata.getSupportsSchemasInTableDefinitions();
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return this.metadata.getSupportsSelectForUpdate();
    }

    @Override
    public boolean supportsStatementPooling() {
        return this.metadata.getSupportsStatementPooling();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return this.metadata.getSupportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public boolean supportsStoredProcedures() {
        return this.metadata.getSupportsStoredProcedures();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return this.metadata.getSupportsSubqueriesInComparisons();
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return this.metadata.getSupportsSubqueriesInExists();
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return this.metadata.getSupportsSubqueriesInIns();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return this.metadata.getSupportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return this.metadata.getSupportsTableCorrelationNames();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return this.metadata.getSupportsTransactionIsolationLevelList().contains(Client.TransactionIsolationLevel.valueOf(level));
    }

    @Override
    public boolean supportsTransactions() {
        return this.metadata.getSupportsTransactions();
    }

    @Override
    public boolean supportsUnion() {
        return this.metadata.getSupportsUnion();
    }

    @Override
    public boolean supportsUnionAll() {
        return this.metadata.getSupportsUnionAll();
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return this.metadata.getUpdatesAreDetectedList().contains(Client.ResultSetType.valueOf(type));
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return this.metadata.getUsesLocalFilePerTable();
    }

    @Override
    public boolean usesLocalFiles() {
        return this.metadata.getUsesLocalFiles();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getMetadata(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PSEUDO_COLUMNS, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return this.metadata.getGeneratedKeyAlwaysReturned();
    }

    private ResultSet getMetadata(Client.MetadataType metadataType) throws SQLException {
        MetadataResponse response = this.conn.getMetadata(SqlRpcOptions.defaultOptions(this.url), metadataType, Collections.emptyList());
        return this.createMetadataResultSet(response);
    }

    private ResultSet getMetadata(Client.MetadataType metadataType, BoundValue ... boundValues) throws SQLException {
        return this.getMetadata(metadataType, Util.toBindVariableProtos(Arrays.asList(boundValues)));
    }

    private ResultSet getMetadata(Client.MetadataType metadataType, String ... parameters) throws SQLException {
        ArrayList<Client.BindVariableProto> bindParameters = Util.newArrayList();
        int position = 1;
        for (String param : parameters) {
            bindParameters.add(BoundValue.of(param, JdbcType.JDBC_TYPE_VARCHAR).toBindVariableProtoBuilder().setPosition(position++).build());
        }
        return this.getMetadata(metadataType, bindParameters);
    }

    private ResultSet getMetadata(Client.MetadataType metadataType, List<Client.BindVariableProto> bindParameters) throws SQLException {
        MetadataResponse response = this.conn.getMetadata(SqlRpcOptions.defaultOptions(this.url), metadataType, bindParameters);
        return this.createMetadataResultSet(response);
    }

    private ResultSet createMetadataResultSet(MetadataResponse response) throws SQLException {
        if (response.hasResult()) {
            Client.RowSetProto rsp = response.getResult().getRows();
            return new ResultSet(this.conn.createStatement(), rsp.getTuplesList(), rsp.getColumnsList(), null, this.conn.getCatalog(), SqlRpcOptions.defaultOptions().setResultSetType(1004));
        }
        return SimpleListResultSet.emptyResultSet();
    }

    static enum ClientInfoColumns {
        NAME,
        MAX_LEN,
        DEFAULT_VALUE,
        DESCRIPTION;

    }

    static enum KeysColumns {
        PKTABLE_CAT,
        PKTABLE_SCHEM,
        PKTABLE_NAME,
        PKCOLUMN_NAME,
        FKTABLE_CAT,
        FKTABLE_SCHEM,
        FKTABLE_NAME,
        FKCOLUMN_NAME,
        KEY_SEQ,
        UPDATE_RULE,
        DELETE_RULE,
        FK_NAME,
        PK_NAME,
        DEFERRABILITY;

    }

    static enum SchemasColumns {
        TABLE_SCHEM,
        TABLE_CATALOG;

    }

    static enum CatalogsColumns {
        TABLE_CAT;

    }

    static enum TableTypesColumns {
        TABLE_TYPE;

    }
}

