/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util;

import com.google.appengine.repackaged.com.google.common.util.Base64DecoderException;
import com.google.appengine.repackaged.com.google.common.util.GwtCompatible;

@GwtCompatible
public final class CharBase64 {
    private static final char PADDING_CHAR = '=';
    private static final char NEW_LINE = '\n';
    private static final char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] websafeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final byte[] decodabet = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};
    private static final byte[] websafeDecodabet = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private CharBase64() {
    }

    public static final char[] getAlphabet() {
        char[] clone = new char[alphabet.length];
        System.arraycopy(alphabet, 0, clone, 0, alphabet.length);
        return clone;
    }

    public static final char[] getWebSafeAlphabet() {
        char[] clone = new char[websafeAlphabet.length];
        System.arraycopy(websafeAlphabet, 0, clone, 0, websafeAlphabet.length);
        return clone;
    }

    private static char[] encode3to4(byte[] source, int srcOffset, int numSigBytes, char[] destination, int destOffset, char[] alphabet) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = alphabet[inBuff >>> 18];
                destination[destOffset + 1] = alphabet[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = alphabet[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = alphabet[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = alphabet[inBuff >>> 18];
                destination[destOffset + 1] = alphabet[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = alphabet[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = alphabet[inBuff >>> 18];
                destination[destOffset + 1] = alphabet[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    @Deprecated
    public static String encode(byte[] source) {
        return CharBase64.encode(source, 0, source.length, alphabet, true);
    }

    @Deprecated
    public static String encodeWebSafe(byte[] source, boolean doPadding) {
        return CharBase64.encode(source, 0, source.length, websafeAlphabet, doPadding);
    }

    public static String encode(byte[] source, int off, int len, char[] alphabet, boolean doPadding) {
        int outLen;
        char[] outBuff = CharBase64.encode(source, off, len, alphabet, Integer.MAX_VALUE);
        for (outLen = outBuff.length; !doPadding && outLen > 0 && outBuff[outLen - 1] == '='; --outLen) {
        }
        return new String(outBuff, 0, outLen);
    }

    static char[] encode(byte[] source, int off, int len, char[] alphabet, int maxLineLength) {
        int lenDiv3 = (len + 2) / 3;
        int len43 = lenDiv3 * 4;
        char[] outBuff = new char[len43 + len43 / maxLineLength];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            int inBuff = source[d + off] << 24 >>> 8 | source[d + 1 + off] << 24 >>> 16 | source[d + 2 + off] << 24 >>> 24;
            outBuff[e] = alphabet[inBuff >>> 18];
            outBuff[e + 1] = alphabet[inBuff >>> 12 & 0x3F];
            outBuff[e + 2] = alphabet[inBuff >>> 6 & 0x3F];
            outBuff[e + 3] = alphabet[inBuff & 0x3F];
            if ((lineLength += 4) == maxLineLength) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            CharBase64.encode3to4(source, d + off, len - d, outBuff, e, alphabet);
            if ((lineLength += 4) == maxLineLength) {
                outBuff[e + 4] = 10;
                ++e;
            }
            e += 4;
        }
        return outBuff;
    }

    private static int decode4to3(char[] source, int srcOffset, byte[] destination, int destOffset, byte[] decodabet) {
        if (source[srcOffset + 2] == '=') {
            int outBuff = decodabet[source[srcOffset]] << 24 >>> 6 | decodabet[source[srcOffset + 1]] << 24 >>> 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == '=') {
            int outBuff = decodabet[source[srcOffset]] << 24 >>> 6 | decodabet[source[srcOffset + 1]] << 24 >>> 12 | decodabet[source[srcOffset + 2]] << 24 >>> 18;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = decodabet[source[srcOffset]] << 24 >>> 6 | decodabet[source[srcOffset + 1]] << 24 >>> 12 | decodabet[source[srcOffset + 2]] << 24 >>> 18 | decodabet[source[srcOffset + 3]] << 24 >>> 24;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    @Deprecated
    public static byte[] decode(String s) throws Base64DecoderException {
        char[] chars = s.toCharArray();
        return CharBase64.decode(chars, 0, chars.length);
    }

    @Deprecated
    public static byte[] decodeWebSafe(String s) throws Base64DecoderException {
        char[] chars = s.toCharArray();
        return CharBase64.decodeWebSafe(chars, 0, chars.length);
    }

    @Deprecated
    static byte[] decode(char[] source) throws Base64DecoderException {
        return CharBase64.decode(source, 0, source.length);
    }

    @Deprecated
    static byte[] decodeWebSafe(char[] source) throws Base64DecoderException {
        return CharBase64.decodeWebSafe(source, 0, source.length);
    }

    @Deprecated
    public static byte[] decode(char[] source, int off, int len) throws Base64DecoderException {
        return CharBase64.decode(source, off, len, decodabet);
    }

    @Deprecated
    static byte[] decodeWebSafe(char[] source, int off, int len) throws Base64DecoderException {
        return CharBase64.decode(source, off, len, websafeDecodabet);
    }

    static byte[] decode(char[] source, int off, int len, byte[] decodabet) throws Base64DecoderException {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[2 + len34];
        int outBuffPosn = 0;
        char[] c4 = new char[4];
        int c4Posn = 0;
        int i = 0;
        char sbiCrop = '\u0000';
        byte sbiDecode = 0;
        boolean paddingCharSeen = false;
        for (i = 0; i < len; ++i) {
            char sbiRaw = source[i + off];
            sbiCrop = (char)(sbiRaw & 0x7F);
            sbiDecode = decodabet[sbiCrop];
            if (sbiCrop == sbiRaw && sbiDecode < -5) {
                throw new Base64DecoderException("Bad Base64 input character at " + i + ": " + source[i + off] + "(decimal)");
            }
            if (sbiDecode < -1) continue;
            if (sbiCrop == '=') {
                if (paddingCharSeen) continue;
                if (i < 2) {
                    throw new Base64DecoderException("Invalid padding char found in position " + i);
                }
                paddingCharSeen = true;
                char lastChar = (char)(source[len - 1 + off] & 0x7F);
                if (lastChar == '=' || lastChar == '\n') continue;
                throw new Base64DecoderException("encoded value has invalid trailing char");
            }
            if (paddingCharSeen) {
                throw new Base64DecoderException("Data found after trailing padding char at index " + i);
            }
            c4[c4Posn++] = sbiCrop;
            if (c4Posn != 4) continue;
            outBuffPosn += CharBase64.decode4to3(c4, 0, outBuff, outBuffPosn, decodabet);
            c4Posn = 0;
        }
        if (c4Posn != 0) {
            if (c4Posn == 1) {
                throw new Base64DecoderException("single trailing character at offset " + (len - 1));
            }
            c4[c4Posn] = 61;
            outBuffPosn += CharBase64.decode4to3(c4, 0, outBuff, outBuffPosn, decodabet);
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }
}

