/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import java.io.Serializable;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SocketApiHelper
implements Serializable {
    static final String PACKAGE = "remote_socket";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("system_error:\\s*(-?\\d+)\\s*,?\\s*error_detail:\\s*\"([^\"]*)\"\\s*");

    SocketApiHelper() {
    }

    static void parseErrorDetail(CharSequence string, SocketServicePb.RemoteSocketServiceError serviceError) {
        Matcher matcher = MESSAGE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return;
        }
        serviceError.setErrorDetail(matcher.group(2));
        serviceError.setSystemError(Integer.parseInt(matcher.group(1)));
    }

    <T extends ProtocolMessage<T>, V extends ProtocolMessage<V>> boolean makeSyncCall(String method, T request, V response, SocketServicePb.RemoteSocketServiceError serviceError) throws SocketException {
        try {
            byte[] responseBytes = this.apiProxyMakeSyncCall(method, request.toByteArray());
            if (responseBytes != null) {
                response.mergeFrom(responseBytes);
            }
            return true;
        }
        catch (ApiProxy.ApplicationException exception) {
            if (serviceError != null) {
                SocketServicePb.RemoteSocketServiceError.ErrorCode errorCode = SocketServicePb.RemoteSocketServiceError.ErrorCode.valueOf(exception.getApplicationError());
                switch (errorCode) {
                    case SYSTEM_ERROR: 
                    case GAI_ERROR: {
                        SocketApiHelper.parseErrorDetail(exception.getErrorDetail(), serviceError);
                        if (!serviceError.hasErrorDetail() && !serviceError.hasSystemError()) break;
                        return false;
                    }
                }
            }
            throw SocketApiHelper.translateError(exception);
        }
        catch (ApiProxy.ApiDeadlineExceededException e) {
            throw new SocketException("Socket operation timed out: " + e.getMessage());
        }
    }

    byte[] apiProxyMakeSyncCall(String method, byte[] request) {
        return ApiProxy.makeSyncCall(PACKAGE, method, request);
    }

    static SocketException translateError(int error, String detail) {
        SocketServicePb.RemoteSocketServiceError.ErrorCode errorCode = SocketServicePb.RemoteSocketServiceError.ErrorCode.valueOf(error);
        switch (errorCode) {
            case SYSTEM_ERROR: {
                return new SocketException("System error: " + detail);
            }
            case GAI_ERROR: {
                return new SocketException("Resolver error: " + detail);
            }
            case FAILURE: {
                return new SocketException("Operation failure: " + detail);
            }
            case PERMISSION_DENIED: {
                return new SocketException("Permission denied: " + detail);
            }
            case INVALID_REQUEST: {
                return new SocketException("Invalid request: " + detail);
            }
            case SOCKET_CLOSED: {
                return new SocketException("Socket is closed: " + detail);
            }
        }
        return new SocketException("Unspecified error (" + errorCode + ") : " + detail);
    }

    static SocketException translateError(ApiProxy.ApplicationException exception) {
        return SocketApiHelper.translateError(exception.getApplicationError(), exception.getErrorDetail());
    }
}

