/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.apphosting.api.AppEngineInternal;

@AppEngineInternal
public final class RequestStatusUtil {
    private static final ImmutableMap<SearchServicePb.SearchServiceError.ErrorCode, Codes.Code> REQUEST_STATUS_TO_CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put(SearchServicePb.SearchServiceError.ErrorCode.OK, Codes.Code.OK).put(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, Codes.Code.INVALID_ARGUMENT).put(SearchServicePb.SearchServiceError.ErrorCode.TRANSIENT_ERROR, Codes.Code.UNAVAILABLE).put(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, Codes.Code.INTERNAL).put(SearchServicePb.SearchServiceError.ErrorCode.PERMISSION_DENIED, Codes.Code.PERMISSION_DENIED).put(SearchServicePb.SearchServiceError.ErrorCode.TIMEOUT, Codes.Code.DEADLINE_EXCEEDED).put(SearchServicePb.SearchServiceError.ErrorCode.CONCURRENT_TRANSACTION, Codes.Code.ABORTED).build();

    public static Codes.Code toCanonicalCode(SearchServicePb.SearchServiceError.ErrorCode appCode) {
        return Preconditions.checkNotNull(REQUEST_STATUS_TO_CANONICAL_ERROR_MAPPING.get(appCode));
    }

    public static SearchServicePb.RequestStatus.Builder newStatusBuilder(SearchServicePb.SearchServiceError.ErrorCode code, String message) {
        SearchServicePb.RequestStatus.Builder builder = SearchServicePb.RequestStatus.newBuilder();
        builder.setCode(code).setCanonicalCode(RequestStatusUtil.toCanonicalCode(code).getNumber());
        if (message != null) {
            builder.setErrorDetail(message);
        }
        return builder;
    }

    public static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode code, String message) {
        return RequestStatusUtil.newStatusBuilder(code, message).build();
    }

    public static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode code) {
        return RequestStatusUtil.newStatusBuilder(code, null).build();
    }

    public static SearchServicePb.RequestStatus newInvalidRequestStatus(IllegalArgumentException e) {
        Preconditions.checkNotNull(e.getMessage());
        return RequestStatusUtil.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, e.getMessage());
    }
}

