/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.MonitoredIndexUsageTracker;
import com.google.appengine.api.datastore.PostLoadContext;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

class QueryResultsSourceImpl
implements QueryResultsSource {
    static Logger logger = Logger.getLogger(QueryResultsSourceImpl.class.getName());
    private static final int AT_LEAST_ONE = -1;
    private static final String DISABLE_CHUNK_SIZE_WARNING_SYS_PROP = "appengine.datastore.disableChunkSizeWarning";
    private static final int CHUNK_SIZE_WARNING_RESULT_SET_SIZE_THRESHOLD = 1000;
    private static final long MAX_CHUNK_SIZE_WARNING_FREQUENCY_MS = 300000L;
    static MonitoredIndexUsageTracker monitoredIndexUsageTracker = new MonitoredIndexUsageTracker();
    static final AtomicLong lastChunkSizeWarning = new AtomicLong(0L);
    private final ApiProxy.ApiConfig apiConfig;
    private final DatastoreCallbacks callbacks;
    private final int chunkSize;
    private final int offset;
    private final Transaction txn;
    private final Query query;
    private final CurrentTransactionProvider currentTransactionProvider;
    private Future<DatastorePb.QueryResult> queryResultFuture;
    private int skippedResults;
    private int totalResults = 0;
    private List<Index> indexList = null;
    private boolean addedSkippedCursor;

    public QueryResultsSourceImpl(ApiProxy.ApiConfig apiConfig, DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, Future<DatastorePb.QueryResult> firstQueryResultFuture) {
        this.apiConfig = apiConfig;
        this.callbacks = callbacks;
        this.chunkSize = fetchOptions.getChunkSize() != null ? fetchOptions.getChunkSize() : -1;
        this.offset = fetchOptions.getOffset() != null ? fetchOptions.getOffset() : 0;
        this.txn = txn;
        this.query = query;
        this.currentTransactionProvider = new CurrentTransactionProvider(){

            @Override
            public Transaction getCurrentTransaction(Transaction defaultValue) {
                return QueryResultsSourceImpl.this.txn;
            }
        };
        this.queryResultFuture = firstQueryResultFuture;
        this.skippedResults = 0;
    }

    @Override
    public boolean hasMoreEntities() {
        return this.queryResultFuture != null;
    }

    @Override
    public int getNumSkipped() {
        return this.skippedResults;
    }

    @Override
    public List<Index> getIndexList() {
        if (this.indexList == null) {
            this.peekQueryResultAndIfFirstRecordIndexList();
        }
        return this.indexList;
    }

    @Override
    public Cursor loadMoreEntities(List<Entity> buffer, List<Cursor> cursorBuffer) {
        return this.loadMoreEntities(-1, buffer, cursorBuffer);
    }

    @Override
    public Cursor loadMoreEntities(int numberToLoad, List<Entity> buffer, List<Cursor> cursorBuffer) {
        TransactionImpl.ensureTxnActive(this.txn);
        if (this.queryResultFuture != null) {
            if (numberToLoad == 0 && this.offset <= this.skippedResults) {
                if (!this.addedSkippedCursor) {
                    cursorBuffer.add(null);
                    this.addedSkippedCursor = true;
                }
                return null;
            }
            int previousSize = buffer.size();
            DatastorePb.QueryResult res = this.peekQueryResultAndIfFirstRecordIndexList();
            this.queryResultFuture = null;
            this.processQueryResult(res, buffer, cursorBuffer);
            if (res.isMoreResults()) {
                DatastorePb.NextRequest req = new DatastorePb.NextRequest();
                req.getMutableCursor().copyFrom(res.getCursor());
                if (res.hasCompiledCursor()) {
                    req.setCompile(true);
                }
                boolean setCount = true;
                if (numberToLoad <= 0) {
                    setCount = false;
                    if (this.chunkSize != -1) {
                        req.setCount(this.chunkSize);
                    }
                    if (numberToLoad == -1) {
                        numberToLoad = 1;
                    }
                }
                while ((this.skippedResults < this.offset || buffer.size() - previousSize < numberToLoad) && res.isMoreResults()) {
                    if (this.skippedResults < this.offset) {
                        req.setOffset(this.offset - this.skippedResults);
                    } else {
                        req.clearOffset();
                    }
                    if (setCount) {
                        req.setCount(Math.max(this.chunkSize, numberToLoad - buffer.size() + previousSize));
                    }
                    this.queryResultFuture = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Next", req, new DatastorePb.QueryResult());
                    res = this.peekQueryResultAndIfFirstRecordIndexList();
                    this.queryResultFuture = null;
                    this.processQueryResult(res, buffer, cursorBuffer);
                }
                if (res.isMoreResults()) {
                    if (this.chunkSize != -1) {
                        req.setCount(this.chunkSize);
                    } else {
                        req.clearCount();
                    }
                    req.clearOffset();
                    this.queryResultFuture = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Next", req, new DatastorePb.QueryResult());
                }
            }
            return res.hasCompiledCursor() ? new Cursor(res.getCompiledCursor()) : null;
        }
        return null;
    }

    private DatastorePb.QueryResult peekQueryResultAndIfFirstRecordIndexList() {
        DatastorePb.QueryResult res = FutureHelper.quietGet(this.queryResultFuture);
        if (this.indexList == null) {
            this.indexList = new ArrayList<Index>(res.indexSize());
            HashSet<Index> monitoredIndexes = null;
            for (OnestoreEntity.CompositeIndex indexProtobuf : res.indexs()) {
                Index index = IndexTranslator.convertFromPb(indexProtobuf);
                this.indexList.add(index);
                if (!indexProtobuf.isOnlyUseIfRequired()) continue;
                if (monitoredIndexes == null) {
                    monitoredIndexes = new HashSet<Index>();
                }
                monitoredIndexes.add(index);
            }
            if (monitoredIndexes != null) {
                monitoredIndexUsageTracker.addNewUsage(monitoredIndexes, this.query);
            }
        }
        return res;
    }

    private void processQueryResult(DatastorePb.QueryResult res, List<Entity> buffer, List<Cursor> cursorBuffer) {
        this.skippedResults += res.getSkippedResults();
        if (this.skippedResults >= this.offset && !this.addedSkippedCursor) {
            cursorBuffer.add(res.hasSkippedResultsCompiledCursor() ? new Cursor(res.getSkippedResultsCompiledCursor()) : null);
            this.addedSkippedCursor = true;
        }
        for (int i = 0; i < res.resultSize(); ++i) {
            OnestoreEntity.EntityProto entityProto = res.getResult(i);
            Collection<Projection> projections = this.query.getProjections();
            Entity entity = projections.isEmpty() ? EntityTranslator.createFromPb(entityProto) : EntityTranslator.createFromPb(entityProto, projections);
            buffer.add(entity);
            cursorBuffer.add(i < res.resultCompiledCursorSize() ? new Cursor(res.getResultCompiledCursor(i)) : null);
            PostLoadContext postLoadContext = new PostLoadContext(this.currentTransactionProvider, entity);
            this.callbacks.executePostLoadCallbacks(postLoadContext);
        }
        this.totalResults += res.resultSize();
        if (this.chunkSize == -1 && this.totalResults > 1000 && System.getProperty(DISABLE_CHUNK_SIZE_WARNING_SYS_PROP) == null) {
            this.logChunkSizeWarning();
        }
    }

    void logChunkSizeWarning() {
        long now = System.currentTimeMillis();
        if (now - lastChunkSizeWarning.get() < 300000L) {
            return;
        }
        logger.warning("This query does not have a chunk size set in FetchOptions and has returned over 1000 results.  If result sets of this size are common for this query, consider setting a chunk size to improve performance.\n  To disable this warning set the following system property in appengine-web.xml (the value of the property doesn't matter): 'appengine.datastore.disableChunkSizeWarning'");
        lastChunkSizeWarning.set(now);
    }
}

