/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.event;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Transport;
import javax.mail.event.MailEvent;
import javax.mail.event.TransportListener;

public class TransportEvent
extends MailEvent {
    public static final int MESSAGE_DELIVERED = 1;
    public static final int MESSAGE_NOT_DELIVERED = 2;
    public static final int MESSAGE_PARTIALLY_DELIVERED = 3;
    protected int type;
    protected transient Address[] validSent;
    protected transient Address[] validUnsent;
    protected transient Address[] invalid;
    protected transient Message msg;

    public TransportEvent(Transport transport, int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message message) {
        super(transport);
        this.type = type;
        this.validSent = validSent;
        this.validUnsent = validUnsent;
        this.invalid = invalid;
        this.msg = message;
    }

    public Address[] getValidSentAddresses() {
        return this.validSent;
    }

    public Address[] getValidUnsentAddresses() {
        return this.validUnsent;
    }

    public Address[] getInvalidAddresses() {
        return this.invalid;
    }

    public Message getMessage() {
        return this.msg;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void dispatch(Object listener) {
        TransportListener l = (TransportListener)listener;
        switch (this.type) {
            case 1: {
                l.messageDelivered(this);
                break;
            }
            case 2: {
                l.messageNotDelivered(this);
                break;
            }
            case 3: {
                l.messagePartiallyDelivered(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + this.type);
            }
        }
    }
}

