/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionImpl
implements Transaction {
    private final ApiProxy.ApiConfig apiConfig;
    private final String app;
    private final long handle;
    private final TransactionStack txnStack;
    TransactionState state = TransactionState.BEGUN;

    TransactionImpl(ApiProxy.ApiConfig apiConfig, String app, long handle, TransactionStack txnStack) {
        this.apiConfig = apiConfig;
        this.app = app;
        this.handle = handle;
        this.txnStack = txnStack;
    }

    void makeSyncCall(String methodName, ProtocolMessage<?> request, ProtocolMessage<?> response) {
        DatastoreApiHelper.makeSyncCall(this.apiConfig, methodName, request, response);
    }

    private void makeSyncCall(String methodName, ProtocolMessage<?> response) {
        if (this.state != TransactionState.BEGUN) {
            throw new IllegalStateException("Transaction is in state " + (Object)((Object)this.state) + ".  There is no legal " + "transition out of this state.");
        }
        DatastorePb.Transaction txn = new DatastorePb.Transaction();
        txn.setApp(this.app);
        txn.setHandle(this.handle);
        try {
            this.makeSyncCall(methodName, txn, response);
        }
        catch (RuntimeException rte) {
            this.state = TransactionState.ERROR;
            throw rte;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            this.makeSyncCall("Commit", new DatastorePb.CommitResponse());
            this.state = TransactionState.COMMITTED;
        }
        finally {
            this.txnStack.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            this.makeSyncCall("Rollback", new ApiBasePb.VoidProto());
            this.state = TransactionState.ROLLED_BACK;
        }
        finally {
            this.txnStack.remove(this);
        }
    }

    @Override
    public String getApp() {
        return this.app;
    }

    @Override
    public String getId() {
        return Long.toString(this.handle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)o;
        return this.handle == that.handle;
    }

    public int hashCode() {
        return (int)(this.handle ^ this.handle >>> 32);
    }

    public String toString() {
        return "Txn [" + this.app + "." + this.handle + ", " + (Object)((Object)this.state) + "]";
    }

    @Override
    public boolean isActive() {
        return this.state == TransactionState.BEGUN;
    }

    static void ensureTxnActive(Transaction txn) {
        if (txn != null && !txn.isActive()) {
            throw new IllegalStateException("Transaction with which this operation is associated is not active.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionState {
        BEGUN,
        COMMITTED,
        ROLLED_BACK,
        ERROR;

    }
}

