/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-10-25 at 08:23:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * SegmentDefinition defines the segment to be a set of SegmentFilters which are combined together
 * with a logical `AND` operation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SegmentDefinition extends com.google.api.client.json.GenericJson {

  /**
   * A segment is defined by a set of segment filters which are combined together with a logical
   * `AND` operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SegmentFilter> segmentFilters;

  static {
    // hack to force ProGuard to consider SegmentFilter used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SegmentFilter.class);
  }

  /**
   * A segment is defined by a set of segment filters which are combined together with a logical
   * `AND` operation.
   * @return value or {@code null} for none
   */
  public java.util.List<SegmentFilter> getSegmentFilters() {
    return segmentFilters;
  }

  /**
   * A segment is defined by a set of segment filters which are combined together with a logical
   * `AND` operation.
   * @param segmentFilters segmentFilters or {@code null} for none
   */
  public SegmentDefinition setSegmentFilters(java.util.List<SegmentFilter> segmentFilters) {
    this.segmentFilters = segmentFilters;
    return this;
  }

  @Override
  public SegmentDefinition set(String fieldName, Object value) {
    return (SegmentDefinition) super.set(fieldName, value);
  }

  @Override
  public SegmentDefinition clone() {
    return (SegmentDefinition) super.clone();
  }

}
