package com.cybelia.sandra.notifier;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author sletellier
 */
public class TemplateHelper {

    protected static final Log log = LogFactory.getLog(TemplateHelper.class);

    /**
     * Return representation of risque of silo
     *
     * @param eleveur concerned
     * @return risk join by ','
     */
    public String extractRisques(Map<String, String> lbl, Eleveur eleveur) {
        if (log.isDebugEnabled()) {
            log.debug("Find risques for breeder '" + eleveur.getRaisonSociale());
        }

        Set<String> allRisque = new HashSet<String>();

        Collection<String> risques = extractRsk(eleveur.getAccesEleveur());
        allRisque.addAll(risques);

        if (log.isDebugEnabled()) {
            log.debug("Acces eleveur risques : " + Arrays.toString(allRisque.toArray()));
        }

        for (InfoAccess silo : eleveur.getActiveAccesSilo()) {
            Collection<String> risquesSilo = extractRsk(silo);
            if (log.isDebugEnabled()) {
                log.debug("Silo riques : " + Arrays.toString(risquesSilo.toArray()));
            }
            allRisque.addAll(risquesSilo);
        }
        if (log.isDebugEnabled()) {
            log.debug("Final breeder riques : " + Arrays.toString(allRisque.toArray()));
        }

        Set<String> allRsk = new HashSet<String>();
        for (String risque : allRisque) {
            allRsk.add(lbl.get("RSK-" + risque));
        }

        String rsks = StringUtils.join(allRsk, ", ");

        if (log.isDebugEnabled()) {
            log.debug("Final risques found : " + rsks);
        }

        return rsks;
    }

    protected Collection<String> extractRsk(InfoAccess ia) {
        return ia.getRisques();
    }
}
