package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.TransporteurDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.csv.bean.IbuTransporteur;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaException;

public class InjectorTransporteur implements Injector {

    protected Transporteur transporteur;

    public Transporteur getObject() {
        return transporteur;
    }

    public void clear() {
        transporteur = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        Camion camion = manager.getCamion();
        transporteur = camion.getTransporteur();
    }

    public void inject(ManagerInjector manager, IbuTransporteur ibuTransporteur) throws TopiaException {
        TransporteurDAO transporteurDAO = SandraDAOHelper.getTransporteurDAO(manager.getTransaction());

        // Recherche
        transporteur = transporteurDAO.findByNaturalId(ibuTransporteur.getCode(),
                                                       manager.getSociete());

        // dont create transporteur any more : #352
        // Création
//        if (transporteur == null) {
//            transporteur = transporteurDAO.createByNaturalId(ibuTransporteur.getCode(), manager.getSociete());
//        }

        if (transporteur != null) {
            // Mise à jour
            transporteur.setName(ibuTransporteur.getName());
        }
    }

    public void inject(ManagerInjector manager, IbuCamion camion) throws TopiaException {
        TransporteurDAO transporteurDAO = SandraDAOHelper.getTransporteurDAO(manager.getTransaction());

        // Recherche
        transporteur = transporteurDAO.findByNaturalId(camion.getTransporteur(),
                                                       manager.getSociete());

        // Création
        if (transporteur == null) {
            transporteur = transporteurDAO.createByNaturalId(camion.getTransporteur(), manager.getSociete());
        }
    }
}
