-- function to replace all words in text placed in start and inline
-- regexp_replace replace only first found
-- CREATE EXTENSION fuzzystrmatch;
CREATE OR REPLACE FUNCTION remove_all_words(field text, words text[])
RETURNS text AS $$
DECLARE field_in text := field;
BEGIN
	-- loop on words
	for _count in 1..array_upper(words, 1) loop
		field_in = regexp_replace(field_in, '^'||words[_count]||' ', '');
		field_in = replace(field_in, ' '||words[_count]||' ', ' ');
	end loop;
	RETURN field_in;

END;
$$ LANGUAGE plpgsql;

-- create view with raisonsociale without keywords
CREATE OR REPLACE VIEW replaced AS SELECT topiaid, remove_all_words(raisonsociale, '{"DE", "LA", "A", "LE", "DU", "L", "D", "DES", "LES", "ET", "ST", "STE", "EARL", "GAEC", "SCEA", "SARL", "ETS", "SCL"}'::text[]) AS raisonsociale2, ville, raisonsociale FROM sandra.eleveur;

-- create view with raisonsociale splited on first space
CREATE OR REPLACE VIEW namesplit AS SELECT topiaid, (regexp_matches(raisonsociale2, E'^([^\\s]+)\\s*(.*)$'))[1] AS name1, (regexp_matches(raisonsociale2, E'^([^\\s]+)\\s*(.*)$'))[2] AS name2, ville, raisonsociale FROM replaced;

-- copy name1 to name2 if name2 is empty
CREATE OR REPLACE VIEW copied AS SELECT topiaid, name1, CASE name2 WHEN '' THEN name1 ELSE name2 END AS name2, ville, raisonsociale FROM namesplit;

-- create function
CREATE OR REPLACE FUNCTION find_duplicate_breeder(text)
RETURNS setof text AS $$

	-- compare with levenshtein all posibility and display only more than 2 results
	SELECT e2.topiaid FROM copied e1, copied e2 WHERE
		e1.topiaid=$1 AND
		e1.topiaid<>e2.topiaid AND
		e1.ville=e2.ville AND
		(levenshtein(e1.name1, e2.name1) < 2 OR
		levenshtein(e1.name1, e2.name2) < 2 OR
		levenshtein(e1.name2, e2.name1) < 2 OR
		levenshtein(e1.name2, e2.name2) < 2);
$$ LANGUAGE SQL;
