/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.Version;
import org.postgresql.Driver;

public class VersionPrinter {
    public static String[] GISVERSIONS = new String[]{"postgis_version", "postgis_proj_version", "postgis_scripts_installed", "postgis_lib_version", "postgis_scripts_released", "postgis_uses_stats", "postgis_geos_version", "postgis_scripts_build_date", "postgis_lib_build_date", "postgis_full_version"};
    public static boolean makeemptyline = false;

    public static void main(String[] stringArray) {
        Driver driver;
        Statement statement = null;
        VersionPrinter.printHeading("PostGIS jdbc client code");
        VersionPrinter.printVersionString("getFullVersion", Version.getFullVersion());
        VersionPrinter.printHeading("PGJDBC Driver");
        VersionPrinter.printVersionString("getVersion", Driver.getVersion());
        try {
            driver = new Driver();
        }
        catch (Exception exception) {
            System.err.println("Cannot create Driver instance: " + exception.getMessage());
            System.exit(1);
            return;
        }
        VersionPrinter.printVersionString("getMajorVersion", driver.getMajorVersion());
        VersionPrinter.printVersionString("getMinorVersion", driver.getMinorVersion());
        if (stringArray.length == 3) {
            Connection connection = null;
            try {
                connection = DriverManager.getConnection(stringArray[0], stringArray[1], stringArray[2]);
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                System.err.println("Connection to database failed, aborting.");
                System.err.println(sQLException.getMessage());
                System.exit(1);
            }
        } else if (stringArray.length != 0) {
            System.err.println("Usage: java examples/VersionPrinter dburl user pass");
            System.exit(1);
            return;
        }
        if (statement == null) {
            System.out.println("No online version available.");
        }
        VersionPrinter.printHeading("PostgreSQL Server");
        VersionPrinter.printVersionString("version", statement);
        VersionPrinter.printHeading("PostGIS Server");
        for (int i = 0; i < GISVERSIONS.length; ++i) {
            VersionPrinter.printVersionString(GISVERSIONS[i], statement);
        }
    }

    private static void printHeading(String string) {
        if (makeemptyline) {
            System.out.println();
        }
        System.out.println("** " + string + " **");
        makeemptyline = true;
    }

    public static void printVersionString(String string, int n) {
        VersionPrinter.printVersionString(string, Integer.toString(n));
    }

    public static void printVersionString(String string, String string2) {
        System.out.println("\t" + string + ": " + string2);
    }

    public static void printVersionString(String string, Statement statement) {
        VersionPrinter.printVersionString(string, VersionPrinter.getVersionString(string, statement));
    }

    public static String getVersionString(String string, Statement statement) {
        try {
            ResultSet resultSet = statement.executeQuery("SELECT " + string + "()");
            if (!resultSet.next()) {
                return "-- no result --";
            }
            String string2 = resultSet.getString(1);
            if (string2 == null) {
                return "-- null result --";
            }
            return string2.trim();
        }
        catch (SQLException sQLException) {
            return "-- unavailable -- ";
        }
    }
}

