/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGgeometry;
import org.postgresql.Driver;
import org.postgresql.util.PGobject;

public class TestAutoregister {
    public static void main(String[] stringArray) {
        ResultSet resultSet;
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length != 3) {
            System.err.println("Usage: java examples/TestParser dburl user pass");
            System.exit(1);
            return;
        }
        System.out.println("Testing proper auto-registration");
        string = stringArray[0];
        string2 = stringArray[1];
        string3 = stringArray[2];
        System.out.println("Driver version: " + Driver.getVersion());
        try {
            n = new Driver().getMajorVersion();
        }
        catch (Exception exception) {
            System.err.println("Cannot create Driver instance: " + exception.getMessage());
            System.exit(1);
            return;
        }
        if (n < 8) {
            System.err.println("Your pgdjbc " + n + ".X is too old, it does not support autoregistration!");
            return;
        }
        System.out.println("Creating JDBC connection to " + string);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            System.err.println("Connection initialization failed, aborting.");
            sQLException.printStackTrace();
            System.exit(1);
            throw new AssertionError();
        }
        int n2 = 0;
        try {
            n2 = TestAutoregister.getPostgisMajor(statement);
        }
        catch (SQLException sQLException) {
            System.err.println("Error fetching PostGIS version: " + sQLException.getMessage());
            System.err.println("Is PostGIS really installed in the database?");
            System.exit(1);
            throw new AssertionError();
        }
        System.out.println("PostGIS Version: " + n2);
        PGobject pGobject = null;
        try {
            resultSet = statement.executeQuery("SELECT 'POINT(1 2)'::geometry");
            resultSet.next();
            pGobject = (PGobject)resultSet.getObject(1);
            if (pGobject instanceof PGgeometry) {
                System.out.println("PGgeometry successful!");
            } else {
                System.out.println("PGgeometry failed!");
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Selecting geometry failed: " + sQLException.getMessage());
            System.exit(1);
            return;
        }
        try {
            resultSet = statement.executeQuery("SELECT 'BOX3D(1 2 3, 4 5 6)'::box3d");
            resultSet.next();
            pGobject = (PGobject)resultSet.getObject(1);
            if (pGobject instanceof PGbox3d) {
                System.out.println("Box3d successful!");
            } else {
                System.out.println("Box3d failed!");
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Selecting box3d failed: " + sQLException.getMessage());
            System.exit(1);
            return;
        }
        if (n2 < 1) {
            System.out.println("PostGIS version is too old, skipping box2ed test");
            System.err.println("PostGIS version is too old, skipping box2ed test");
        } else {
            try {
                resultSet = statement.executeQuery("SELECT 'BOX(1 2,3 4)'::box2d");
                resultSet.next();
                pGobject = (PGobject)resultSet.getObject(1);
                if (pGobject instanceof PGbox2d) {
                    System.out.println("Box2d successful!");
                } else {
                    System.out.println("Box2d failed! " + pGobject.getClass().getName());
                }
            }
            catch (SQLException sQLException) {
                System.err.println("Selecting box2d failed: " + sQLException.getMessage());
                System.exit(1);
                return;
            }
        }
        System.out.println("Finished.");
        System.err.println("TestAutoregister.java finished without errors.");
    }

    public static int getPostgisMajor(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT postgis_version()");
        resultSet.next();
        String string = resultSet.getString(1);
        if (string == null) {
            throw new SQLException("postgis_version returned NULL!");
        }
        string = string.trim();
        int n = string.indexOf(46);
        return Integer.parseInt(string.substring(0, n));
    }
}

