/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.CommandeDAO;
import com.cybelia.sandra.ibu.ModifsCollector;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.injector.InjectorTour;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorCommande
implements Injector {
    private final Log log = LogFactory.getLog(InjectorCommande.class);
    protected Commande commande;
    protected boolean commandeCreated = false;

    @Override
    public Commande getObject() {
        return this.commande;
    }

    public boolean isCommandeCreated() {
        return this.commandeCreated;
    }

    @Override
    public void clear() {
        this.commande = null;
        this.commandeCreated = false;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        CommandeDAO commandeDAO = SandraDAOHelper.getCommandeDAO(manager.getTransaction());
        String commandeCode = ibu.getCommandeCode();
        this.commande = commandeDAO.findByNaturalId(commandeCode);
        if (this.commande == null) {
            this.commande = commandeDAO.createByNaturalId(commandeCode);
            this.commandeCreated = true;
        }
        ModifsCollector modifsCollector = new ModifsCollector();
        modifsCollector.add(Commande.class, "commentaire", this.commande.getCommentaire(), ibu.getCommandeCommentaire());
        if (modifsCollector.isModified()) {
            manager.getInjector(InjectorTour.class).setCommandeCommentaireIsModif(true);
        }
        boolean wasActif = this.commande.isActif();
        if ("GUI".equals(ibu.getCamionCode())) {
            this.commande.setActif(false);
        } else {
            this.commande.setActif(true);
        }
        ModifsCollector modifsActifCollector = new ModifsCollector();
        modifsActifCollector.add(Commande.class, "actif", wasActif, this.commande.isActif());
        if (modifsActifCollector.isModified()) {
            manager.getInjector(InjectorTour.class).setCommandeActifChange(true);
        }
        this.commande.setCommentaire(ibu.getCommandeCommentaire());
        this.commande.setContrainteHoraire(ibu.getCommandeMoment());
    }
}

