/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.UserIndicateurs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class CamionAbstract
extends TopiaEntityAbstract
implements Camion {
    protected String code;
    protected int nombreCompartiments;
    protected boolean actif;
    protected List<Camion> camionsAssocies;
    protected Collection<Chauffeur> defautChauffeurs;
    protected Transporteur transporteur;
    protected Societe societe;
    protected UserIndicateurs userIndicateurs;
    private static final long serialVersionUID = 3991652949140977977L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "code", String.class, (Object)this.code);
        visitor.visit((TopiaEntity)this, "nombreCompartiments", Integer.TYPE, (Object)this.nombreCompartiments);
        visitor.visit((TopiaEntity)this, "actif", Boolean.TYPE, (Object)this.actif);
        visitor.visit((TopiaEntity)this, "camionsAssocies", List.class, Camion.class, this.camionsAssocies);
        visitor.visit((TopiaEntity)this, "defautChauffeurs", Collection.class, Chauffeur.class, this.defautChauffeurs);
        visitor.visit((TopiaEntity)this, "transporteur", Transporteur.class, (Object)this.transporteur);
        visitor.visit((TopiaEntity)this, "societe", Societe.class, (Object)this.societe);
        visitor.visit((TopiaEntity)this, "userIndicateurs", UserIndicateurs.class, (Object)this.userIndicateurs);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        this.fireOnPreWrite("code", oldValue, code);
        this.code = code;
        this.fireOnPostWrite("code", oldValue, code);
    }

    @Override
    public String getCode() {
        this.fireOnPreRead("code", this.code);
        String result = this.code;
        this.fireOnPostRead("code", this.code);
        return result;
    }

    @Override
    public void setNombreCompartiments(int nombreCompartiments) {
        int oldValue = this.nombreCompartiments;
        this.fireOnPreWrite("nombreCompartiments", oldValue, nombreCompartiments);
        this.nombreCompartiments = nombreCompartiments;
        this.fireOnPostWrite("nombreCompartiments", oldValue, nombreCompartiments);
    }

    @Override
    public int getNombreCompartiments() {
        this.fireOnPreRead("nombreCompartiments", this.nombreCompartiments);
        int result = this.nombreCompartiments;
        this.fireOnPostRead("nombreCompartiments", this.nombreCompartiments);
        return result;
    }

    @Override
    public void setActif(boolean actif) {
        boolean oldValue = this.actif;
        this.fireOnPreWrite("actif", oldValue, actif);
        this.actif = actif;
        this.fireOnPostWrite("actif", oldValue, actif);
    }

    @Override
    public boolean isActif() {
        this.fireOnPreRead("actif", this.actif);
        boolean result = this.actif;
        this.fireOnPostRead("actif", this.actif);
        return result;
    }

    @Override
    public boolean getActif() {
        this.fireOnPreRead("actif", this.actif);
        boolean result = this.actif;
        this.fireOnPostRead("actif", this.actif);
        return result;
    }

    @Override
    public void addCamionsAssocies(Camion camionsAssocies) {
        this.fireOnPreWrite("camionsAssocies", null, camionsAssocies);
        if (this.camionsAssocies == null) {
            this.camionsAssocies = new ArrayList<Camion>();
        }
        this.camionsAssocies.add(camionsAssocies);
        this.fireOnPostWrite("camionsAssocies", this.camionsAssocies.size(), null, camionsAssocies);
    }

    @Override
    public void addAllCamionsAssocies(List<Camion> camionsAssocies) {
        if (camionsAssocies == null) {
            return;
        }
        for (Camion item : camionsAssocies) {
            this.addCamionsAssocies(item);
        }
    }

    @Override
    public void setCamionsAssocies(List<Camion> camionsAssocies) {
        ArrayList<Camion> oldValue = this.camionsAssocies != null ? new ArrayList<Camion>(this.camionsAssocies) : null;
        this.fireOnPreWrite("camionsAssocies", oldValue, camionsAssocies);
        this.camionsAssocies = camionsAssocies;
        this.fireOnPostWrite("camionsAssocies", oldValue, camionsAssocies);
    }

    @Override
    public void removeCamionsAssocies(Camion camionsAssocies) {
        this.fireOnPreWrite("camionsAssocies", camionsAssocies, null);
        if (this.camionsAssocies == null || !this.camionsAssocies.remove(camionsAssocies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("camionsAssocies", this.camionsAssocies.size() + 1, camionsAssocies, null);
    }

    @Override
    public void clearCamionsAssocies() {
        if (this.camionsAssocies == null) {
            return;
        }
        ArrayList<Camion> oldValue = new ArrayList<Camion>(this.camionsAssocies);
        this.fireOnPreWrite("camionsAssocies", oldValue, this.camionsAssocies);
        this.camionsAssocies.clear();
        this.fireOnPostWrite("camionsAssocies", oldValue, this.camionsAssocies);
    }

    @Override
    public List<Camion> getCamionsAssocies() {
        return this.camionsAssocies;
    }

    @Override
    public Camion getCamionsAssociesByTopiaId(String topiaId) {
        return (Camion)TopiaEntityHelper.getEntityByTopiaId(this.camionsAssocies, (String)topiaId);
    }

    @Override
    public int sizeCamionsAssocies() {
        if (this.camionsAssocies == null) {
            return 0;
        }
        return this.camionsAssocies.size();
    }

    @Override
    public boolean isCamionsAssociesEmpty() {
        int size = this.sizeCamionsAssocies();
        return size == 0;
    }

    @Override
    public void addDefautChauffeurs(Chauffeur defautChauffeurs) {
        this.fireOnPreWrite("defautChauffeurs", null, defautChauffeurs);
        if (this.defautChauffeurs == null) {
            this.defautChauffeurs = new ArrayList<Chauffeur>();
        }
        if (defautChauffeurs.getCamions() == null) {
            defautChauffeurs.setCamions(new ArrayList<Camion>());
        }
        defautChauffeurs.getCamions().add(this);
        this.defautChauffeurs.add(defautChauffeurs);
        this.fireOnPostWrite("defautChauffeurs", this.defautChauffeurs.size(), null, defautChauffeurs);
    }

    @Override
    public void addAllDefautChauffeurs(Collection<Chauffeur> defautChauffeurs) {
        if (defautChauffeurs == null) {
            return;
        }
        for (Chauffeur item : defautChauffeurs) {
            this.addDefautChauffeurs(item);
        }
    }

    @Override
    public void setDefautChauffeurs(Collection<Chauffeur> defautChauffeurs) {
        ArrayList<Chauffeur> oldValue = this.defautChauffeurs != null ? new ArrayList<Chauffeur>(this.defautChauffeurs) : null;
        this.fireOnPreWrite("defautChauffeurs", oldValue, defautChauffeurs);
        this.defautChauffeurs = defautChauffeurs;
        this.fireOnPostWrite("defautChauffeurs", oldValue, defautChauffeurs);
    }

    @Override
    public void removeDefautChauffeurs(Chauffeur defautChauffeurs) {
        this.fireOnPreWrite("defautChauffeurs", defautChauffeurs, null);
        if (this.defautChauffeurs == null || !this.defautChauffeurs.remove(defautChauffeurs)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        defautChauffeurs.getCamions().remove(this);
        this.fireOnPostWrite("defautChauffeurs", this.defautChauffeurs.size() + 1, defautChauffeurs, null);
    }

    @Override
    public void clearDefautChauffeurs() {
        if (this.defautChauffeurs == null) {
            return;
        }
        for (Chauffeur item : this.defautChauffeurs) {
            item.getCamions().remove(this);
        }
        ArrayList<Chauffeur> oldValue = new ArrayList<Chauffeur>(this.defautChauffeurs);
        this.fireOnPreWrite("defautChauffeurs", oldValue, this.defautChauffeurs);
        this.defautChauffeurs.clear();
        this.fireOnPostWrite("defautChauffeurs", oldValue, this.defautChauffeurs);
    }

    @Override
    public Collection<Chauffeur> getDefautChauffeurs() {
        return this.defautChauffeurs;
    }

    @Override
    public Chauffeur getDefautChauffeursByTopiaId(String topiaId) {
        return (Chauffeur)TopiaEntityHelper.getEntityByTopiaId(this.defautChauffeurs, (String)topiaId);
    }

    @Override
    public int sizeDefautChauffeurs() {
        if (this.defautChauffeurs == null) {
            return 0;
        }
        return this.defautChauffeurs.size();
    }

    @Override
    public boolean isDefautChauffeursEmpty() {
        int size = this.sizeDefautChauffeurs();
        return size == 0;
    }

    @Override
    public void setTransporteur(Transporteur transporteur) {
        Transporteur oldValue = this.transporteur;
        this.fireOnPreWrite("transporteur", oldValue, transporteur);
        this.transporteur = transporteur;
        this.fireOnPostWrite("transporteur", oldValue, transporteur);
    }

    @Override
    public Transporteur getTransporteur() {
        this.fireOnPreRead("transporteur", this.transporteur);
        Transporteur result = this.transporteur;
        this.fireOnPostRead("transporteur", this.transporteur);
        return result;
    }

    @Override
    public void setSociete(Societe societe) {
        Societe oldValue = this.societe;
        this.fireOnPreWrite("societe", oldValue, societe);
        this.societe = societe;
        this.fireOnPostWrite("societe", oldValue, societe);
    }

    @Override
    public Societe getSociete() {
        this.fireOnPreRead("societe", this.societe);
        Societe result = this.societe;
        this.fireOnPostRead("societe", this.societe);
        return result;
    }

    @Override
    public void setUserIndicateurs(UserIndicateurs userIndicateurs) {
        UserIndicateurs oldValue = this.userIndicateurs;
        this.fireOnPreWrite("userIndicateurs", oldValue, userIndicateurs);
        this.userIndicateurs = userIndicateurs;
        this.fireOnPostWrite("userIndicateurs", oldValue, userIndicateurs);
    }

    @Override
    public UserIndicateurs getUserIndicateurs() {
        this.fireOnPreRead("userIndicateurs", this.userIndicateurs);
        UserIndicateurs result = this.userIndicateurs;
        this.fireOnPostRead("userIndicateurs", this.userIndicateurs);
        return result;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("code", (Object)this.code).append("nombreCompartiments", this.nombreCompartiments).append("actif", this.actif).append("camionsAssocies", this.camionsAssocies).append("transporteur", (Object)this.transporteur).append("societe", (Object)this.societe).append("userIndicateurs", (Object)this.userIndicateurs).toString();
        return result;
    }
}

