/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfigProvider;

public class ApplicationConfigHelper {
    private static final Log log = LogFactory.getLog(ApplicationConfigHelper.class);

    protected ApplicationConfigHelper() {
    }

    public static Set<ApplicationConfigProvider> getProviders(ClassLoader classLoader, Set<String> includes, Set<String> excludes, boolean verbose) {
        ServiceLoader<ApplicationConfigProvider> loader = classLoader == null ? ServiceLoader.load(ApplicationConfigProvider.class) : ServiceLoader.load(ApplicationConfigProvider.class, classLoader);
        HashSet<ApplicationConfigProvider> result = new HashSet<ApplicationConfigProvider>();
        for (ApplicationConfigProvider configProvider : loader) {
            String name = configProvider.getName();
            if (includes != null && !includes.contains(name)) {
                if (!verbose) continue;
                log.info((Object)("configuration named '" + name + "' is rejected by includes."));
                continue;
            }
            if (excludes != null && excludes.contains(name)) {
                if (!verbose) continue;
                log.info((Object)("configuration named '" + name + "' is rejected by excludes."));
                continue;
            }
            if (verbose) {
                log.info((Object)("configuration named '" + name + "' will be generated."));
            }
            result.add(configProvider);
        }
        return result;
    }

    public static ApplicationConfigProvider getProvider(ClassLoader classLoader, String name) {
        Set<ApplicationConfigProvider> providers = ApplicationConfigHelper.getProviders(classLoader, null, null, false);
        ApplicationConfigProvider result = null;
        for (ApplicationConfigProvider provider : providers) {
            if (!name.equals(provider.getName())) continue;
            result = provider;
            break;
        }
        return result;
    }
}

