/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.PKeyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private Document mappingDoc;
    private String packageName;

    public MappingsGenerator(String packageName) {
        this.packageName = packageName;
    }

    public void write(Writer writer) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(this.mappingDoc);
        xmlWriter.close();
    }

    public Document getMappingsDoc() {
        return this.mappingDoc;
    }

    public void load(List<ClassInfo> mappedClasses) throws PKeyNotFoundException {
        this.mappingDoc = DocumentHelper.createDocument();
        this.mappingDoc.addDocType("hibernate-mapping", "-//Hibernate/Hibernate Mapping DTD 3.0//EN", "http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd");
        Element root = this.mappingDoc.addElement("hibernate-mapping").addAttribute("package", this.packageName);
        for (ClassInfo classInfo : mappedClasses) {
            this.addTableElement(root, classInfo);
        }
    }

    private void addTableElement(Element root, ClassInfo classInfo) throws PKeyNotFoundException {
        Element tableEl = root.addElement("class");
        tableEl.addAttribute("name", classInfo.getClassName());
        tableEl.addAttribute("table", classInfo.getTableName());
        AttributeInfo idAttr = classInfo.getIdAttribute();
        this.addColElement(tableEl, idAttr);
        for (AttributeInfo ai : classInfo.getAttributes()) {
            if (ai.isIdentifier()) continue;
            this.addColElement(tableEl, ai);
        }
    }

    private void addColElement(Element tableEl, AttributeInfo ai) {
        Element colEl = null;
        colEl = ai.isIdentifier() ? tableEl.addElement("id") : tableEl.addElement("property");
        colEl.addAttribute("name", ai.getFieldName());
        colEl.addAttribute("column", ai.getColumnName());
        colEl.addAttribute("type", ai.getHibernateType());
    }
}

