/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.cfg.Configuration;
import org.hibernatespatial.cfg.HSProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSConfiguration
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(HSConfiguration.class);
    private String source = "runtime configuration object";
    private HSProperty[] HSProperties = HSProperty.values();

    public String getDefaultDialect() {
        return this.getProperty(HSProperty.DEFAULT_DIALECT.toString());
    }

    public void setDefaultDialect(String dialect) {
        this.setProperty(HSProperty.DEFAULT_DIALECT, dialect);
    }

    public String getPrecisionModel() {
        return this.getProperty(HSProperty.PRECISION_MODEL.toString());
    }

    public void setPrecisionModel(String precisionModel) {
        this.setProperty(HSProperty.PRECISION_MODEL, precisionModel);
    }

    public String getPrecisionModelScale() {
        return this.getProperty(HSProperty.PRECISION_MODEL_SCALE.toString());
    }

    public void setPrecisionModelScale(String scale) {
        this.setProperty(HSProperty.PRECISION_MODEL_SCALE, scale);
    }

    protected String getProperty(HSProperty property) {
        return this.getProperty(property.toString());
    }

    protected void setProperty(HSProperty property, String value) {
        this.setProperty(property.toString(), value);
    }

    public boolean configure(Configuration hibernateConfig) {
        String dialect = hibernateConfig.getProperty("hibernate.dialect");
        this.setProperty(HSProperty.DEFAULT_DIALECT, dialect);
        return true;
    }

    public boolean configure() {
        return this.configure("hibernate-spatial.cfg.xml");
    }

    public boolean configure(File resource) {
        logger.info("Attempting to configuring from file: " + resource.getName());
        try {
            this.source = resource.getAbsolutePath();
            return this.doConfigure(new FileInputStream(resource));
        }
        catch (FileNotFoundException e) {
            logger.warn("could not find file: " + resource + ".");
        }
        catch (DocumentException e) {
            logger.warn("Failed to load configuration file: " + resource + ".\nCause:" + e.getMessage());
        }
        return false;
    }

    public String getSource() {
        return this.source;
    }

    public boolean configure(String resource) {
        logger.debug("Attempting to load configuration from file: " + resource);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            URL url = classLoader.getResource(resource);
            if (url == null) {
                logger.info("No configuration file " + resource + " on the classpath.");
                return false;
            }
            this.source = url.getFile();
            return this.doConfigure(url.openStream());
        }
        catch (Exception e) {
            logger.warn("Failed to load configuration file: " + resource + ".\nCause:" + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConfigure(InputStream stream) throws DocumentException {
        try {
            SAXReader reader = new SAXReader();
            Document configDoc = reader.read(stream);
            Element root = configDoc.getRootElement();
            for (HSProperty hsprop : this.HSProperties) {
                Element propEl = root.element(hsprop.toString().toLowerCase());
                if (propEl == null) continue;
                this.setProperty(hsprop, propEl.getText());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        return this.source;
    }
}

