/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

public class InjectorCamion
implements Injector {
    private final Log log = LogFactory.getLog(InjectorCamion.class);
    protected Camion camion;

    public Camion getObject() {
        return this.camion;
    }

    @Override
    public void clear() {
        this.camion = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        String[] splited;
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)manager.getTransaction());
        String camionCodeSociete = ibu.getCamionCodeSociete();
        if (StringUtils.isNotEmpty((CharSequence)camionCodeSociete) && (splited = camionCodeSociete.split("-")).length == 2) {
            SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)manager.getTransaction());
            String codeSociete = splited[0];
            String codeCamion = splited[1];
            Societe societe = societeDAO.findByCode(codeSociete);
            this.camion = camionDAO.findByNaturalId(codeCamion, societe);
        }
        if (this.camion == null) {
            String camionCode = ibu.getCamionCode();
            this.camion = camionDAO.findByNaturalId(camionCode, manager.getSociete());
        }
        if (this.camion == null) {
            this.camion = camionDAO.findByNaturalId("GUI", manager.getSociete());
        }
    }

    public void inject(ManagerInjector manager, IbuCamion ibuCamion) throws TopiaException {
        TopiaContext transaction = manager.getTransaction();
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)transaction);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO((TopiaContext)transaction);
        Societe societe = manager.getSociete();
        this.camion = camionDAO.findByNaturalId(ibuCamion.getCode(), societe);
        if (this.camion == null) {
            this.camion = camionDAO.createByNaturalId(ibuCamion.getCode(), societe);
            TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)transaction);
            TaasUser taasUser = (TaasUser)taasUserDAO.create(new Object[0]);
            taasUser.setLogin(societe.getCode() + "-" + this.camion.getCode());
            taasUser.setLink(societe.getTopiaId());
            taasUser.setEnabled(true);
            TaasPrincipalDAO taasPrincipalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)transaction);
            TaasPrincipal synchroPrincipal = taasPrincipalDAO.findByName("synchro");
            TaasPrincipal taasPrincipal = (TaasPrincipal)taasPrincipalDAO.create(new Object[0]);
            taasPrincipal.setName(societe.getCode() + "-" + this.camion.getCode());
            taasPrincipalDAO.update((TopiaEntity)taasPrincipal);
            taasUser.addPrincipals(taasPrincipal);
            taasUser.addPrincipals(synchroPrincipal);
            taasUser = (TaasUser)taasUserDAO.update((TopiaEntity)taasUser);
            UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
            UserIndicateurs userIndicateurs = userIndicateursDAO.createByNaturalId(taasUser);
            userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);
            this.camion.setUserIndicateurs(userIndicateurs);
            this.camion.setActif(true);
        }
        this.camion.setNombreCompartiments(ibuCamion.getNbCompartiment());
        this.camion.setTransporteur(manager.getTransporteur());
        String codePrincipal = ibuCamion.getCodePrincipal();
        if (StringUtils.isNotEmpty((CharSequence)codePrincipal)) {
            Societe societeAssocie = societeDAO.findByCode(codePrincipal.substring(0, 1));
            Camion principal = camionDAO.findByNaturalId(codePrincipal.substring(2), societeAssocie);
            ArrayList<Camion> camionsAssocies = principal.getCamionsAssocies();
            if (camionsAssocies == null) {
                camionsAssocies = new ArrayList<Camion>();
                principal.setCamionsAssocies(camionsAssocies);
            }
            if (!camionsAssocies.contains(this.camion)) {
                camionsAssocies.add(this.camion);
            }
        }
    }
}

