/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.CommentVisitor;
import com.github.therapi.runtimejavadoc.Link;
import com.github.therapi.runtimejavadoc.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ToTextListCommentVisitor
implements CommentVisitor {
    protected List<String> lines = new ArrayList<String>();

    @Override
    public void commentText(String value) {
        String[] splits = value.split("\r\n|\n");
        this.lines.addAll(Arrays.asList(splits));
    }

    @Override
    public void inlineLink(Link link) {
        this.appendInlineText(link.toString());
    }

    @Override
    public void inlineTag(String name, String value) {
        this.appendInlineText(value);
    }

    @Override
    public void inlineValue(Value value) {
        this.appendInlineText(value.toString());
    }

    public List<String> build() {
        return this.lines;
    }

    private void appendInlineText(String txt) {
        if (txt != null) {
            if (this.lines.isEmpty()) {
                this.lines.add(txt);
            } else {
                int index = this.lines.size() - 1;
                String newLine = this.lines.get(index) + txt;
                this.lines.set(index, newLine);
            }
        }
    }
}

