/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.services.javascript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.StylesheetLink;
import org.got5.tapestry5.jquery.services.EffectsParam;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JQueryJavaScriptStack
implements JavaScriptStack {
    private final boolean productionMode;
    private String jQueryAlias;
    private final boolean suppressPrototype;
    private final List<Asset> jQueryJsStack;
    private final AssetSource assetSource;
    private final JavaScriptStackSource jsStackSource;
    private SymbolSource symbolSource;
    private EffectsParam effectsParam;

    public JQueryJavaScriptStack(final @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="jquery.alias") String jQueryAlias, @Symbol(value="suppress.prototype") boolean suppressPrototype, final AssetSource assetSource, JavaScriptStackSource jsStackSrc, final SymbolSource symbolSource, EffectsParam effectsParam) {
        this.productionMode = productionMode;
        this.suppressPrototype = suppressPrototype;
        this.assetSource = assetSource;
        this.jQueryAlias = jQueryAlias;
        this.jsStackSource = jsStackSrc;
        this.symbolSource = symbolSource;
        this.effectsParam = effectsParam;
        Mapper<String, Asset> pathToAsset = new Mapper<String, Asset>(){

            public Asset map(String path) {
                if (productionMode) {
                    String pathMin = symbolSource.expandSymbols(path);
                    if (path.equalsIgnoreCase("${jquery.core.path}")) {
                        path = new StringBuffer(pathMin).insert(pathMin.lastIndexOf(".js"), ".min").toString();
                    } else if (path.contains("${jquery.ui.path}")) {
                        path = new StringBuffer(pathMin).insert(pathMin.lastIndexOf(".js"), ".min").insert(pathMin.lastIndexOf(47), "/minified").toString();
                    }
                }
                return assetSource.getExpandedAsset(path);
            }
        };
        Mapper pathToStylesheetLink = F.combine((Mapper)pathToAsset, JQueryUtils.assetToStylesheetLink);
        this.jQueryJsStack = F.flow((Object[])new String[]{"${jquery.core.path}", "${jquery.ui.path}/jquery.ui.core.js", "${jquery.ui.path}/jquery.ui.position.js", "${jquery.ui.path}/jquery.ui.widget.js", "${jquery.ui.path}/jquery.effects.core.js", "${tapestry.jquery.path}/jquery.json-2.2.js"}).concat(F.flow(this.effectsParam.getEffectsToLoad())).map((Mapper)pathToAsset).toList();
    }

    public String getInitialization() {
        if (!this.suppressPrototype && this.jQueryAlias.equals("$")) {
            this.jQueryAlias = "$j";
        }
        return this.productionMode ? "var " + this.jQueryAlias + " = jQuery;" : "var " + this.jQueryAlias + " = jQuery; Tapestry.DEBUG_ENABLED = true; var selector = new Array();";
    }

    public Object chooseJavascript(Asset asset) {
        if (this.suppressPrototype) {
            if (asset.getResource().getFile().endsWith("t5-prototype.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/t5-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("tapestry.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/tapestry-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("t5-console.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/t5-console-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("t5-dom.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/t5-dom-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("t5-alerts.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/t5-alerts-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("t5-ajax.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/t5-ajax-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("tree.js")) {
                return this.assetSource.getExpandedAsset("${tapestry.jquery.path}/t5-tree-jquery.js");
            }
            if (asset.getResource().getFile().endsWith("prototype.js") || asset.getResource().getFile().endsWith("scriptaculous.js") || asset.getResource().getFile().endsWith("effects.js") || asset.getResource().getFile().endsWith("exceptiondisplay.js")) {
                return null;
            }
        }
        return asset;
    }

    public List<Asset> getJavaScriptLibraries() {
        ArrayList<Asset> ret = new ArrayList<Asset>();
        if (this.suppressPrototype) {
            ret.add(this.assetSource.getExpandedAsset("${tapestry.js.path}"));
        }
        ret.addAll(this.jQueryJsStack);
        if (!this.suppressPrototype) {
            ret.add(this.assetSource.getExpandedAsset("${tapestry.jquery.path}/noconflict.js"));
        }
        for (Asset asset : this.jsStackSource.getStack("prototype.js.stack").getJavaScriptLibraries()) {
            if ((asset = (Asset)this.chooseJavascript(asset)) == null) continue;
            ret.add(asset);
        }
        if (!this.suppressPrototype) {
            ret.add(this.assetSource.getExpandedAsset("${tapestry.jquery.path}/jquery-noconflict.js"));
        }
        return ret;
    }

    public List<StylesheetLink> getStylesheets() {
        ArrayList<StylesheetLink> ret = new ArrayList<StylesheetLink>();
        if (!this.suppressPrototype) {
            ret.addAll(this.jsStackSource.getStack("prototype.js.stack").getStylesheets());
        } else {
            for (StylesheetLink css : this.jsStackSource.getStack("prototype.js.stack").getStylesheets()) {
                if (!css.getURL().endsWith("t5-alerts.css") && !css.getURL().endsWith("tapestry-console.css") && !css.getURL().endsWith("tree.css")) continue;
                ret.add(css);
            }
        }
        return ret;
    }

    public List<String> getStacks() {
        return Collections.emptyList();
    }
}

