/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.util.HashMap;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Widget {
    @Parameter(required=true, defaultPrefix="literal")
    private String name;
    @Parameter(defaultPrefix="literal")
    private Object options;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    @Symbol(value="jquery.alias")
    private String jqueryAlias;
    private String[] stacks;
    private HashMap<String, JSONObject> optionsMap;

    @SetupRender
    public void addTheJSLibs() {
        this.stacks = this.name.split(",");
        if (this.resources.isBound("options")) {
            if (this.options != "") {
                Class optionsType = this.resources.getBoundType("options");
                if (HashMap.class.equals((Object)optionsType)) {
                    this.optionsMap = (HashMap)this.options;
                } else if (JSONObject.class.equals((Object)optionsType)) {
                    this.optionsMap = new HashMap();
                    this.optionsMap.put(this.stacks[0], (JSONObject)this.options);
                } else if (String.class.equals((Object)optionsType)) {
                    this.optionsMap = new HashMap();
                    this.optionsMap.put(this.stacks[0], new JSONObject((String)this.options));
                }
            }
        } else {
            this.optionsMap = new HashMap();
        }
    }

    @BeginRender
    void startDiv(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.clientId});
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        this.resources.renderInformalParameters(writer);
        writer.end();
        for (String stack : this.stacks) {
            this.javaScriptSupport.importStack(stack);
            JSONObject params = this.optionsMap.get(stack);
            if (params == null) {
                params = new JSONObject();
            }
            String init = String.format("%s('#%s').%s(%s);", this.jqueryAlias, this.clientId, stack, params);
            this.javaScriptSupport.addScript(init, new Object[0]);
        }
    }
}

