/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.ClassificationMetric;

public class Sensitivity
implements ClassificationMetric {
    private static final long serialVersionUID = 2L;
    public static final Sensitivity instance = new Sensitivity();

    @Override
    public double score(int[] truth, int[] prediction) {
        return Sensitivity.of(truth, prediction);
    }

    public static double of(int[] truth, int[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int tp = 0;
        int p = 0;
        for (int i = 0; i < truth.length; ++i) {
            if (truth[i] != 0 && truth[i] != 1) {
                throw new IllegalArgumentException("Sensitivity can only be applied to binary classification: " + truth[i]);
            }
            if (prediction[i] != 0 && prediction[i] != 1) {
                throw new IllegalArgumentException("Sensitivity can only be applied to binary classification: " + prediction[i]);
            }
            if (truth[i] != 1) continue;
            ++p;
            if (prediction[i] != 1) continue;
            ++tp;
        }
        return (double)tp / (double)p;
    }

    public String toString() {
        return "Sensitivity";
    }
}

