/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.transform;

import java.io.Serializable;
import java.util.HashMap;
import smile.data.DataFrame;
import smile.data.transform.InvertibleColumnTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.MathEx;
import smile.util.function.Function;

public interface MaxAbsScaler {
    public static InvertibleColumnTransform fit(DataFrame data, String ... columns) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        if (columns.length == 0) {
            columns = (String[])schema.fields().stream().filter(StructField::isNumeric).map(StructField::name).toArray(String[]::new);
        }
        HashMap<String, 1> transforms = new HashMap<String, 1>();
        HashMap<String, Function & Serializable> inverses = new HashMap<String, Function & Serializable>();
        for (String column : columns) {
            final StructField field = schema.field(column);
            if (!field.isNumeric()) {
                throw new IllegalArgumentException(String.format("%s is not numeric", field.name()));
            }
            double[] vector = data.column(column).toDoubleArray();
            double max = 0.0;
            for (double xi : vector) {
                max = Math.max(max, Math.abs(xi));
            }
            final double scale = MathEx.isZero((double)max) ? 1.0 : max;
            Function transform = new Function(){

                public double f(double x) {
                    return x / scale;
                }

                public String toString() {
                    return String.format("%s / %.4f", field.name(), scale);
                }
            };
            Function & Serializable inverse = (Function & Serializable)x -> x * scale;
            transforms.put(field.name(), transform);
            inverses.put(field.name(), inverse);
        }
        return new InvertibleColumnTransform("MaxAbsScaler", transforms, inverses);
    }
}

