/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.foreign.MemorySegment;
import smile.linalg.UPLO;
import smile.tensor.ScalarType;
import smile.tensor.SymmMatrix;

class SymmMatrix64
extends SymmMatrix
implements Serializable {
    final double[] ap;

    private SymmMatrix64() {
        this.ap = null;
    }

    public SymmMatrix64(UPLO uplo, int n, double[] ap) {
        super(MemorySegment.ofArray(ap), uplo, n);
        this.ap = ap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.memory = MemorySegment.ofArray(this.ap);
    }

    @Override
    public ScalarType scalarType() {
        return ScalarType.Float64;
    }

    @Override
    public long length() {
        return this.ap.length;
    }

    @Override
    public double get(int i, int j) {
        return switch (this.uplo) {
            default -> throw new MatchException(null, null);
            case UPLO.LOWER -> {
                if (j > i) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                yield this.ap[i + (2 * this.n - j - 1) * j / 2];
            }
            case UPLO.UPPER -> {
                if (i > j) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                yield this.ap[i + j * (j + 1) / 2];
            }
        };
    }

    @Override
    public void set(int i, int j, double x) {
        switch (this.uplo) {
            case LOWER: {
                if (j > i) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                this.ap[i + (2 * this.n - j - 1) * j / 2] = x;
                break;
            }
            case UPPER: {
                if (i > j) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                this.ap[i + j * (j + 1) / 2] = x;
            }
        }
    }

    @Override
    public void add(int i, int j, double x) {
        switch (this.uplo) {
            case LOWER: {
                if (j > i) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + (2 * this.n - j - 1) * j / 2;
                this.ap[n] = this.ap[n] + x;
                break;
            }
            case UPPER: {
                if (i > j) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + j * (j + 1) / 2;
                this.ap[n] = this.ap[n] + x;
            }
        }
    }

    @Override
    public void sub(int i, int j, double x) {
        switch (this.uplo) {
            case LOWER: {
                if (j > i) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + (2 * this.n - j - 1) * j / 2;
                this.ap[n] = this.ap[n] - x;
                break;
            }
            case UPPER: {
                if (i > j) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + j * (j + 1) / 2;
                this.ap[n] = this.ap[n] - x;
            }
        }
    }

    @Override
    public void mul(int i, int j, double x) {
        switch (this.uplo) {
            case LOWER: {
                if (j > i) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + (2 * this.n - j - 1) * j / 2;
                this.ap[n] = this.ap[n] * x;
                break;
            }
            case UPPER: {
                if (i > j) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + j * (j + 1) / 2;
                this.ap[n] = this.ap[n] * x;
            }
        }
    }

    @Override
    public void div(int i, int j, double x) {
        switch (this.uplo) {
            case LOWER: {
                if (j > i) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + (2 * this.n - j - 1) * j / 2;
                this.ap[n] = this.ap[n] / x;
                break;
            }
            case UPPER: {
                if (i > j) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = i + j * (j + 1) / 2;
                this.ap[n] = this.ap[n] / x;
            }
        }
    }

    @Override
    public SymmMatrix copy() {
        return new SymmMatrix64(this.uplo, this.n, (double[])this.ap.clone());
    }
}

