/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.type.StructField;
import smile.data.vector.ValueVector;

public abstract class AbstractVector
implements ValueVector {
    final StructField field;

    public AbstractVector(StructField field) {
        this.field = field;
    }

    public String toString() {
        int limit = Math.min(this.size(), 10);
        String prefix = this.field.name() + "[";
        String suffix = this.size() > 10 ? String.format(", ..., %d more]", this.size() - 10) : "]";
        return IntStream.range(0, limit).mapToObj(i -> this.field().toString(this.get(i))).collect(Collectors.joining(", ", prefix, suffix));
    }

    @Override
    public StructField field() {
        return this.field;
    }

    IntStream index() {
        return IntStream.range(0, this.size());
    }

    static BitSet bitSet(boolean[] vector) {
        BitSet bits = new BitSet(vector.length);
        for (int i = 0; i < vector.length; ++i) {
            if (!vector[i]) continue;
            bits.set(i);
        }
        return bits;
    }
}

