/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InputStreamHandler;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;

final class ProcessExecutor {
    private final File workingDirectory;
    private final List<String> command;
    private final ProcessBuilder processBuilder;
    private final Platform platform;

    public ProcessExecutor(File workingDirectory, List<String> command, Platform platform) {
        this.workingDirectory = workingDirectory;
        this.command = command;
        this.platform = platform;
        this.processBuilder = this.createProcessBuilder();
    }

    public String executeAndGetResult() throws ProcessExecutionException {
        try {
            Process process = this.processBuilder.start();
            String result = ProcessExecutor.readString(process.getInputStream());
            String error = ProcessExecutor.readString(process.getInputStream());
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                return result;
            }
            throw new ProcessExecutionException(result + " " + error);
        }
        catch (IOException e) {
            throw new ProcessExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ProcessExecutionException(e);
        }
    }

    public int executeAndRedirectOutput(Logger logger) throws ProcessExecutionException {
        try {
            this.processBuilder.redirectErrorStream(true);
            Process process = this.processBuilder.start();
            InputStreamHandler infoLogThread = InputStreamHandler.logInfo(process.getInputStream(), logger);
            infoLogThread.start();
            InputStreamHandler errorLogThread = InputStreamHandler.logError(process.getErrorStream(), logger);
            errorLogThread.start();
            int result = process.waitFor();
            infoLogThread.join();
            errorLogThread.join();
            return result;
        }
        catch (IOException e) {
            throw new ProcessExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ProcessExecutionException(e);
        }
    }

    private ProcessBuilder createProcessBuilder() {
        return new ProcessBuilder(this.getPlatformIndependentCommand()).directory(this.workingDirectory);
    }

    private List<String> getPlatformIndependentCommand() {
        if (this.platform.isWindows()) {
            return this.command;
        }
        return Utils.merge(Arrays.asList("sh", this.workingDirectory + "/node/with_new_path.sh"), this.command);
    }

    private static String readString(InputStream processInputStream) throws IOException {
        String line;
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(processInputStream));
        StringBuffer result = new StringBuffer();
        while ((line = inputStream.readLine()) != null) {
            result.append(line + "\n");
        }
        return result.toString().trim();
    }
}

