/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.util;

import com.github.dozermapper.core.util.DozerClassLoader;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.core.util.ResourceLoader;
import java.net.URL;
import org.apache.commons.lang3.ClassUtils;

public class DefaultClassLoader
implements DozerClassLoader {
    private final ClassLoader classLoader;
    private final ResourceLoader resourceLoader;

    public DefaultClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.resourceLoader = new ResourceLoader(classLoader);
    }

    @Override
    public Class<?> loadClass(String className) {
        Class result = null;
        try {
            result = ClassUtils.getClass((ClassLoader)this.classLoader, (String)className);
        }
        catch (ClassNotFoundException e) {
            try {
                result = ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)className);
            }
            catch (ClassNotFoundException cnfe) {
                MappingUtils.throwMappingException(e);
            }
        }
        return result;
    }

    @Override
    public URL loadResource(String uri) {
        return this.resourceLoader.getResource(uri);
    }
}

