/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.dozer.config.BeanContainer;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;

public final class MappingValidator {
    private MappingValidator() {
    }

    public static void validateMappingRequest(Object srcObj) {
        if (srcObj == null) {
            MappingUtils.throwMappingException("Source object must not be null");
        }
    }

    public static void validateMappingRequest(Object srcObj, Object destObj) {
        MappingValidator.validateMappingRequest(srcObj);
        if (destObj == null) {
            MappingUtils.throwMappingException("Destination object must not be null");
        }
    }

    public static void validateMappingRequest(Object srcObj, Class<?> destClass) {
        MappingValidator.validateMappingRequest(srcObj);
        if (destClass == null) {
            MappingUtils.throwMappingException("Destination class must not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL validateURL(String fileName) {
        DozerClassLoader tccl;
        URL url;
        DozerClassLoader classLoader = BeanContainer.getInstance().getClassLoader();
        if (fileName == null) {
            MappingUtils.throwMappingException("File name is null");
        }
        if ((url = classLoader.loadResource(fileName)) == null && (url = (tccl = BeanContainer.getInstance().getTCCL()).loadResource(fileName)) == null) {
            MappingUtils.throwMappingException("Unable to locate dozer mapping file [" + fileName + "] in the classpath!");
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            MappingUtils.throwMappingException("Unable to open URL input stream for dozer mapping file [" + url + "]");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    MappingUtils.throwMappingException("Unable to close input stream for dozer mapping file [" + url + "]");
                }
            }
        }
        return url;
    }
}

