/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.metadata;

import java.util.ArrayList;
import java.util.List;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.MappingDirection;
import org.dozer.fieldmap.FieldMap;
import org.dozer.metadata.ClassMappingMetadata;
import org.dozer.metadata.DozerFieldMappingMetadata;
import org.dozer.metadata.FieldMappingMetadata;
import org.dozer.metadata.MetadataLookupException;

public final class DozerClassMappingMetadata
implements ClassMappingMetadata {
    private final ClassMap classMap;

    public DozerClassMappingMetadata(ClassMap classMap) {
        this.classMap = classMap;
    }

    @Override
    public String getSourceClassName() {
        return this.classMap.getSrcClassName();
    }

    @Override
    public String getDestinationClassName() {
        return this.classMap.getDestClassName();
    }

    @Override
    public Class<?> getSourceClass() {
        return this.classMap.getSrcClassToMap();
    }

    @Override
    public Class<?> getDestinationClass() {
        return this.classMap.getDestClassToMap();
    }

    @Override
    public boolean isStopOnErrors() {
        return this.classMap.isStopOnErrors();
    }

    @Override
    public boolean isTrimStrings() {
        return this.classMap.isTrimStrings();
    }

    @Override
    public boolean isWildcard() {
        return this.classMap.isWildcard();
    }

    @Override
    public boolean isSourceMapNull() {
        return this.classMap.isSrcMapNull();
    }

    @Override
    public boolean isDestinationMapNull() {
        return this.classMap.isDestMapNull();
    }

    @Override
    public boolean isSourceMapEmptyString() {
        return this.classMap.isSrcMapEmptyString();
    }

    @Override
    public boolean isDestinationMapEmptyString() {
        return this.classMap.isDestMapEmptyString();
    }

    @Override
    public String getDateFormat() {
        return this.classMap.getDateFormat();
    }

    @Override
    public MappingDirection getMappingDirection() {
        return this.classMap.getType();
    }

    @Override
    public String getMapId() {
        return this.classMap.getMapId();
    }

    @Override
    public List<FieldMappingMetadata> getFieldMappings() {
        ArrayList<FieldMappingMetadata> fieldMapCats = new ArrayList<FieldMappingMetadata>();
        for (FieldMap fieldMap : this.classMap.getFieldMaps()) {
            fieldMapCats.add(new DozerFieldMappingMetadata(fieldMap));
        }
        return fieldMapCats;
    }

    @Override
    public FieldMappingMetadata getFieldMappingBySource(String sourceFieldName) {
        FieldMap fieldMap = this.classMap.getFieldMapUsingSrc(sourceFieldName);
        if (fieldMap == null) {
            throw new MetadataLookupException("Field mapping " + sourceFieldName + " not found for class " + this.classMap.getSrcClassName());
        }
        return new DozerFieldMappingMetadata(fieldMap);
    }

    @Override
    public FieldMappingMetadata getFieldMappingByDestination(String destinationFieldName) {
        FieldMap fieldMap = this.classMap.getFieldMapUsingDest(destinationFieldName);
        if (fieldMap == null) {
            throw new MetadataLookupException("Field mapping " + destinationFieldName + " not found for class " + this.classMap.getDestClassName());
        }
        return new DozerFieldMappingMetadata(fieldMap);
    }
}

