package com.franciaflex.faxtomail.ui.swing.content.attachment;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: AttachmentModelAware.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/attachment/AttachmentModelAware.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;

import java.io.Serializable;
import java.util.Collection;

/**
 * To place on model wich supports attachments.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.2
 */
public interface AttachmentModelAware extends Serializable {

    String PROPERTY_ATTACHMENT = "attachment";

    String PROPERTY_OBJECT_ID = "objectId";

//    AttachementObjectTypeEnum getObjectType();

//    Integer getObjectId();

    Collection<Attachment> getAttachment();

    void addAllAttachment(Collection<Attachment> attachments);

    void addAttachment(Attachment attachment);

    void removeAttachment(Attachment attachment);

}
