/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;

public class ReplyFormUIModel
extends AbstractSerializableBean {
    private static final Log log = LogFactory.getLog(ReplyFormUIModel.class);
    public static final String PROPERTY_TO = "to";
    public static final String PROPERTY_FROM = "from";
    public static final String PROPERTY_SUBJECT = "subject";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_ORIGINAL_DEMAND = "originalDemand";
    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_READONLY = "readonly";
    public static final String PROPERTY_MAX_ATTACHMENT_LENGHT = "maxAttachmentLength";
    public static final String PROPERTY_TOTAL_ATTACHMENT_LENGHT = "totalAttachmentLength";
    public static final String PROPERTY_VALID = "valid";
    protected String to;
    protected String from;
    protected String subject;
    protected String message;
    protected DemandeUIModel originalDemand;
    protected long maxAttachmentLength = 0L;
    protected long totalAttachmentLength = 0L;
    protected boolean valid = true;
    protected boolean readonly = false;
    protected Set<AttachmentFile> attachments = new HashSet<AttachmentFile>();
    protected Set<AttachmentFile> availableAttachments = new HashSet<AttachmentFile>();
    protected File lastVisitedDirectory = FileUtils.getUserDirectory();

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        String oldValue = this.getTo();
        this.to = to;
        this.firePropertyChange(PROPERTY_TO, oldValue, to);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        String oldValue = this.getFrom();
        this.from = from;
        this.firePropertyChange(PROPERTY_FROM, oldValue, from);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        String oldValue = this.getSubject();
        this.subject = subject;
        this.firePropertyChange(PROPERTY_SUBJECT, oldValue, subject);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.getMessage();
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public DemandeUIModel getOriginalDemand() {
        return this.originalDemand;
    }

    public void setOriginalDemand(DemandeUIModel originalDemand) {
        DemandeUIModel oldValue = this.getOriginalDemand();
        this.originalDemand = originalDemand;
        this.firePropertyChange(PROPERTY_ORIGINAL_DEMAND, oldValue, originalDemand);
    }

    public Set<AttachmentFile> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(AttachmentFile attachment) {
        this.attachments.add(attachment);
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
        Long oldValue = this.getTotalAttachmentLength();
        this.totalAttachmentLength += attachment.getLength();
        this.firePropertyChange(PROPERTY_TOTAL_ATTACHMENT_LENGHT, oldValue, this.getTotalAttachmentLength());
        this.recomputeValidity();
    }

    public void removeAttachment(AttachmentFile attachment) {
        this.attachments.remove(attachment);
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
        Long oldValue = this.getTotalAttachmentLength();
        this.totalAttachmentLength -= attachment.getLength();
        this.firePropertyChange(PROPERTY_TOTAL_ATTACHMENT_LENGHT, oldValue, this.getTotalAttachmentLength());
        this.recomputeValidity();
    }

    public Set<AttachmentFile> getAvailableAttachments() {
        return this.availableAttachments;
    }

    public void addAvailableAttachment(AttachmentFile attachment) {
        this.availableAttachments.add(attachment);
    }

    public void removeAvailableAttachment(AttachmentFile attachment) {
        this.availableAttachments.remove(attachment);
    }

    public File getLastVisitedDirectory() {
        return this.lastVisitedDirectory;
    }

    public void setLastVisitedDirectory(File lastVisitedDirectory) {
        this.lastVisitedDirectory = lastVisitedDirectory;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        Boolean oldValue = this.isReadonly();
        this.readonly = readonly;
        this.firePropertyChange(PROPERTY_READONLY, oldValue, readonly);
    }

    public long getMaxAttachmentLength() {
        return this.maxAttachmentLength / 1024L;
    }

    public void setMaxAttachmentLength(long maxAttachmentLength) {
        Long oldValue = this.getMaxAttachmentLength();
        this.maxAttachmentLength = maxAttachmentLength;
        this.firePropertyChange(PROPERTY_MAX_ATTACHMENT_LENGHT, oldValue, maxAttachmentLength);
        this.recomputeValidity();
    }

    public long getTotalAttachmentLength() {
        return this.totalAttachmentLength / 1024L;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        Boolean oldValue = this.isValid();
        this.valid = valid;
        this.firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }

    public void recomputeValidity() {
        this.setValid(this.totalAttachmentLength < this.maxAttachmentLength);
    }
}

