package com.franciaflex.faxtomail.ui.swing.content.transmit;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: MailFolderChooserUIHandler.java 111 2014-05-30 10:02:38Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/transmit/MailFolderChooserUIHandler.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.*;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class MailFolderChooserUIHandler extends AbstractFaxToMailUIHandler<DemandeUIModel, MailFolderChooserUI> implements Cancelable {

    private static final Log log = LogFactory.getLog(MailFolderChooserUIHandler.class);

    @Override
    public void afterInit(MailFolderChooserUI mailFolderChooserUI) {
        initUI(mailFolderChooserUI);

        DemandeUIModel model = getModel();

        EtatAttente etatAttente = model.getEtatAttente();
        final Collection<MailFolder> foldersWithEtatAttente;
        if (etatAttente != null) {
            foldersWithEtatAttente = getContext().getMailFolderService().getFoldersWithEtatAttente(etatAttente);
        } else {
            foldersWithEtatAttente = new HashSet<MailFolder>();
        }

        // init tree
//        Company franciaflex = getContext().getCurrentCompany();
        Collection<MailFolder> folders = getContext().getMailFolderService().getRootMailFolders();
        JTree navigationTree = ui.getNavigationTree();

        Map<MailFolder, DefaultMutableTreeNode> nodesByFolder =
                FaxToMailUIUtil.initFolderTree(getContext(), navigationTree, folders);
        MailFolder currentFolder = getModel().getMailFolder();

        for (MailFolder folder : nodesByFolder.keySet()) {
            DefaultMutableTreeNode node = nodesByFolder.get(folder);
            if (node.getClass().isAssignableFrom(FolderTreeNode.class)) {
                FolderTreeNode folderTreeNode = (FolderTreeNode) node;
                folderTreeNode.setCanSelect(!currentFolder.equals(folder) &&
                                                    (CollectionUtils.isNotEmpty(foldersWithEtatAttente)
                                                        || foldersWithEtatAttente.contains(folder)));
            }
        }

        navigationTree.setCellRenderer(new DefaultTreeCellRenderer() {
            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel,
                                                          boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

                FolderTreeNode node = (FolderTreeNode) value;
                setEnabled(node.isCanSelect());

                return component;
            }
        });

        navigationTree.addTreeSelectionListener(new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FolderTreeNode folderNode = (FolderTreeNode) e.getPath().getLastPathComponent();
                MailFolder folder = folderNode.getMailFolder();
                if (!folderNode.isCanSelect()) {
                    folder = null;
                }
                getModel().setMailFolder(folder);
            }
        });
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        closeDialog();
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ui.getNavigationTree();
    }

}
