package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class DemandRepliesUI extends AbstractToolbarPopupUI<com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel, DemandRepliesUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NO_REPLY_LABEL_VISIBLE = "noReplyLabel.visible";
    public static final String BINDING_REPLIES_VISIBLE = "replies.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UTW8cRRAtb7ze2E4IJIoJSpDGiRIckfRaQpyMIB/GwtYGUJZIFnuhd6a9bqenu+muiWexQPwEfgLcuSBx44Q4cObABfEXEOLAFVHdO96PeBNbWa1GM11Vr1+9rtff/wV172B5j5clc4VGmQu2dXd7+6PunkhxXfjUSYvGweA3U4NaBxaz4bpHuNZphfJmVd68b3JrtNBj1WstWPDYV8LvCoEIr09WpN4328PwWmkLd4g6JDUN9dt//q59k339XQ2gtMSuQa0kx1WNOpltQU1mCOdppye8qbjuEQ0ndY/4ng1r9xX3/kOei8/hK2i0YM5yR2AIV0/ecsSI9aVFOOuEVVL4dcmV6SFspSZnO47rVPIdJUq2w0s0OZeKFZL5fSLDUqORsFkmcq4zwSoIth6/Hw6+Hm1aG7eZQ6jnJhMK4e4LgA9AxaPNBwFjhDnbNVkfYdm4Htuj83+Mxg4gSra1/YlEJbKPuR4vuZyNE7xH9e3UGaVCGsKrQeCyYrE1ioTic0OMeWKrIy6d00RFXAxZ54fJZ7QJm/VbvHs0Py6GxIvD/EalJFF9Rlu8q0RV4+DyxGjR0LLR0I6maqYDdVeogHqpc3TOH1JoMOGXnprwABij/y1d+P2nP3/cOBzr4NCLU1PHXEnjZp2xwmFs6NxgpguUqvmA27UOzHuhyNLRslemEGtXYSJH+70SylkoZx9wv0sQ9cYfP/+y9Nlvp6C2AQvK8GyDh/xNmMddRyoYlZX2vTuR0Zn90/R8OXBDWMyllnmRt+UXJNTVg0SL/STi831k60RAe2n0yturq7eS1ZvJlyWpc2WKOkOK3flf/73Q/uHOoUIzxPi1Z6aPVKp/CnNSK6lFtH7l6qlWX7ReFJkZuXean+FpQ9tq+q/F5xvT1Khj8ArdgSMzTviExXhZBIA3Y2/h7TZUFjxuh1nKQ1HiczYQuUWycuOJ9LIbqFw/SHoCo+FXbjJ6rTLpQ/r3Q/YKnQrCwg5dFrejCkhCIlcypZeucRnNHawdJOOOuxeXB0PSZ6kTHEUEGwRW3rqVVP945Ef7nbDzcX3Xxhu6cZAsn6ij0yKjNmLNLLpiquyHt8QJznZO8b4pSPuX3sk48qQrdUZSvHsEdiY8lwjxf/WthyuBBwAA";
    private static final Log log = LogFactory.getLog(DemandRepliesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane demandRepliesBodyScrollPane;
    protected final DemandRepliesUIHandler handler = new DemandRepliesUIHandler();
    protected JPanel mainPanel;
    protected DemandeUIModel model;
    protected JLabel noReplyLabel;
    protected JXTable replies;
    protected DemandRepliesUI repliesDialog = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandRepliesUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public DemandRepliesUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandRepliesUI() {
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DemandRepliesUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandRepliesUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandRepliesUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandRepliesUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandRepliesUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandRepliesUI(Window param0) {
        super(param0);
        $initialize();
    }

    public DemandRepliesUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JScrollPane getDemandRepliesBodyScrollPane() {
        return demandRepliesBodyScrollPane;
    }

    public DemandRepliesUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public DemandeUIModel getModel() {
        return model;
    }

    public JLabel getNoReplyLabel() {
        return noReplyLabel;
    }

    public JXTable getReplies() {
        return replies;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(DemandeUIModel model) {
        DemandeUIModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(demandRepliesBodyScrollPane);
    }

    protected void addChildrenToDemandRepliesBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        demandRepliesBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(noReplyLabel, BorderLayout.NORTH);
        mainPanel.add(replies, BorderLayout.CENTER);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.demandReplies.title"));
    }

    protected void createDemandRepliesBodyScrollPane() {
        $objectMap.put("demandRepliesBodyScrollPane", demandRepliesBodyScrollPane = new JScrollPane());
        
        demandRepliesBodyScrollPane.setName("demandRepliesBodyScrollPane");
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createNoReplyLabel() {
        $objectMap.put("noReplyLabel", noReplyLabel = new JLabel());
        
        noReplyLabel.setName("noReplyLabel");
        noReplyLabel.setText(t("faxtomail.demandReplies.empty"));
        if (noReplyLabel.getFont() != null) {
            noReplyLabel.setFont(noReplyLabel.getFont().deriveFont(noReplyLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createReplies() {
        $objectMap.put("replies", replies = new JXTable());
        
        replies.setName("replies");
        replies.setEditable(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToDemandRepliesBodyScrollPane();
        addChildrenToMainPanel();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setMinimumSize( new java.awt.Dimension(500, 0) );
        noReplyLabel.setBorder( javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3) );
        // late initializer
        repliesDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("repliesDialog", repliesDialog);
        createModel();
        createDemandRepliesBodyScrollPane();
        createMainPanel();
        createNoReplyLabel();
        createReplies();
        // inline creation of repliesDialog
        setName("repliesDialog");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NO_REPLY_LABEL_VISIBLE, true ,"model") {
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getReplies() != null) {
                    noReplyLabel.setVisible( getModel().getReplies().isEmpty() );
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPLIES_VISIBLE, true ,"model") {
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getReplies() != null) {
                    replies.setVisible( !getModel().getReplies().isEmpty() );
                }
            }
        });
    }

}