/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.LdapService;
import com.franciaflex.faxtomail.services.service.ldap.AuthenticationException;
import com.franciaflex.faxtomail.services.service.ldap.Contact;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class LdapServiceImpl
extends FaxToMailServiceSupport
implements LdapService {
    private static final Log log = LogFactory.getLog(LdapServiceImpl.class);

    @Override
    public void updateLdapData() {
        try (LDAPConnection connection = null;){
            connection = new LDAPConnection(this.getApplicationConfig().getLdapHost(), this.getApplicationConfig().getLdapPort(), this.getApplicationConfig().getLdapUser(), this.getApplicationConfig().getLdapPassword());
            if (connection.isConnected()) {
                FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
                FaxToMailUserGroupTopiaDao faxtomailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
                HashMap<String, FaxToMailUserGroup> groupCache = new HashMap<String, FaxToMailUserGroup>();
                HashMap<String, FaxToMailUser> userCache = new HashMap<String, FaxToMailUser>();
                String groupsBaseDN = "OU=Mac-Groupe,DC=mac-groupe,DC=net";
                String groupsFilter = "(objectCategory=CN=Group,CN=Schema,CN=Configuration,DC=mac-groupe,DC=net)";
                SearchResult groupsResult = connection.search(groupsBaseDN, SearchScope.SUB, groupsFilter, new String[0]);
                List groupEntries = groupsResult.getSearchEntries();
                for (SearchResultEntry groupEntry : groupEntries) {
                    String groupDN = groupEntry.getDN();
                    String groupPath = this.getGroupCompleteName(groupDN);
                    String groupName = StringUtils.substringAfterLast((String)groupPath, (String)"/");
                    FaxToMailUserGroup userGroup = (FaxToMailUserGroup)faxtomailUserGroupDao.forNameEquals(groupName).findUniqueOrNull();
                    if (userGroup == null) {
                        userGroup = (FaxToMailUserGroup)faxtomailUserGroupDao.create("name", (Object)groupName, new Object[]{"completeName", groupPath});
                    }
                    groupCache.put(groupDN, userGroup);
                }
                String usersBaseDN = "OU=Mac-Groupe,DC=mac-groupe,DC=net";
                String usersFilter = "(objectCategory=CN=Person,CN=Schema,CN=Configuration,DC=mac-groupe,DC=net)";
                SearchResult usersResult = connection.search(usersBaseDN, SearchScope.SUB, "(objectClass=organizationalUnit)", new String[0]);
                List unitEntries = usersResult.getSearchEntries();
                for (SearchResultEntry unitEntry : unitEntries) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Search for unit " + unitEntry.getDN()));
                    }
                    SearchResult userResult = connection.search(unitEntry.getDN(), SearchScope.ONE, usersFilter, new String[0]);
                    List userEntries = userResult.getSearchEntries();
                    for (SearchResultEntry userEntry : userEntries) {
                        String login = userEntry.getAttributeValue("sAMAccountName");
                        String userDN = userEntry.getDN();
                        if (login == null) {
                            if (!log.isWarnEnabled()) continue;
                            log.warn((Object)("Null sAMAccountName for DN " + userDN));
                            continue;
                        }
                        login = login.toLowerCase();
                        FaxToMailUser user = this.updateUserFormLdap(connection, userEntry, login, groupCache);
                        userCache.put(userDN, user);
                    }
                }
                List usersToHide = faxtomailUserDao.forNotIn(userCache.values());
                for (FaxToMailUser userToHide : usersToHide) {
                    userToHide.setHidden(true);
                    faxtomailUserDao.update((TopiaEntity)userToHide);
                }
                List userGroupsToHide = faxtomailUserGroupDao.forNotIn(groupCache.values());
                for (FaxToMailUserGroup userGroupToHide : userGroupsToHide) {
                    userGroupToHide.setHidden(true);
                    faxtomailUserGroupDao.update((TopiaEntity)userGroupToHide);
                }
                this.getPersistenceContext().commit();
            }
        }
    }

    protected String getGroupCompleteName(String groupCN) {
        Object[] parts = groupCN.split(",");
        ArrayUtils.reverse((Object[])parts);
        String separator = "";
        StringBuilder result = new StringBuilder();
        for (Object part : parts) {
            result.append(separator);
            result.append(StringUtils.substringAfter((String)part, (String)"="));
            separator = "/";
        }
        return result.toString();
    }

    @Override
    public FaxToMailUser getUserBean(String userTopiaId) {
        FaxToMailUserImpl result = null;
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)faxtomailUserDao.forTopiaIdEquals(userTopiaId).findUniqueOrNull();
        if (user != null) {
            Binder faxToMailUserBinder = BinderFactory.newBinder(FaxToMailUser.class);
            result = new FaxToMailUserImpl();
            faxToMailUserBinder.copyExcluding((Object)user, (Object)result, new String[0]);
        }
        return result;
    }

    @Override
    public FaxToMailUser authenticateUser(String login, String password) throws AuthenticationException {
        FaxToMailUser result;
        login = login.toLowerCase();
        try {
            LDAPConnection userConnect;
            LDAPConnection adminConnect = new LDAPConnection();
            adminConnect.connect(this.getApplicationConfig().getLdapHost(), this.getApplicationConfig().getLdapPort());
            adminConnect.bind(this.getApplicationConfig().getLdapUser(), this.getApplicationConfig().getLdapPassword());
            String userDN = null;
            SearchResultEntry searchEntry = null;
            if (adminConnect.isConnected()) {
                String filter = String.format("(sAMAccountName=%s)", login);
                SearchResult searchResult = adminConnect.search(this.getApplicationConfig().getLdapBaseDn(), SearchScope.SUB, filter, new String[0]);
                if (!searchResult.getSearchEntries().isEmpty()) {
                    searchEntry = (SearchResultEntry)searchResult.getSearchEntries().get(0);
                    userDN = searchEntry.getDN();
                }
            }
            if (searchEntry != null) {
                userConnect = new LDAPConnection();
                userConnect.connect(this.getApplicationConfig().getLdapHost(), this.getApplicationConfig().getLdapPort());
                userConnect.bind(userDN, password);
                if (!userConnect.isConnected()) {
                    throw new AuthenticationException("Not connected");
                }
            } else {
                throw new AuthenticationException("Utilisateur inconnu : " + login);
            }
            result = this.updateUserFormLdap(adminConnect, searchEntry, login, null);
            this.getPersistenceContext().commit();
            userConnect.close();
            adminConnect.close();
        }
        catch (LDAPException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't login to ldap", (Throwable)ex);
            }
            throw new AuthenticationException(ex.getResultCode().getName(), ex);
        }
        return result;
    }

    @Override
    public FaxToMailUser getUserFromPrincipal(String login) throws AuthenticationException {
        FaxToMailUser result;
        login = login.toLowerCase();
        try {
            LDAPConnection adminConnect = new LDAPConnection();
            adminConnect.connect(this.getApplicationConfig().getLdapHost(), this.getApplicationConfig().getLdapPort());
            adminConnect.bind(this.getApplicationConfig().getLdapUser(), this.getApplicationConfig().getLdapPassword());
            SearchResultEntry searchEntry = null;
            if (adminConnect.isConnected()) {
                String filter = String.format("(sAMAccountName=%s)", login);
                SearchResult searchResult = adminConnect.search(this.getApplicationConfig().getLdapBaseDn(), SearchScope.SUB, filter, new String[0]);
                if (!searchResult.getSearchEntries().isEmpty()) {
                    searchEntry = (SearchResultEntry)searchResult.getSearchEntries().get(0);
                }
            } else {
                throw new AuthenticationException("Utilisateur inconnu : " + login);
            }
            if (searchEntry == null) {
                throw new AuthenticationException("Utilisateur inconnu : " + login);
            }
            result = this.updateUserFormLdap(adminConnect, searchEntry, login, null);
            this.getPersistenceContext().commit();
            adminConnect.close();
        }
        catch (LDAPException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't login to ldap", (Throwable)ex);
            }
            throw new AuthenticationException(ex.getResultCode().getName(), ex);
        }
        return result;
    }

    protected FaxToMailUser updateUserFormLdap(LDAPConnection adminConnect, SearchResultEntry searchEntry, String login, Map<String, FaxToMailUserGroup> groupCache) throws LDAPException {
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUserGroupTopiaDao faxtomailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        FaxToMailUser user = (FaxToMailUser)faxtomailUserDao.forLoginEquals(login).findUniqueOrNull();
        if (user == null) {
            user = new FaxToMailUserImpl();
            user.setLogin(login);
        }
        user.setHidden(false);
        String fullName = searchEntry.getAttributeValue("name");
        if (fullName.indexOf(32) != -1) {
            String lastName = fullName.substring(0, fullName.indexOf(32));
            String firstName = fullName.substring(fullName.indexOf(32) + 1);
            user.setFirstName(firstName);
            user.setLastName(lastName);
        } else {
            user.setFirstName("");
            user.setLastName(fullName);
        }
        String trigraph = searchEntry.getAttributeValue("sAMAccountName");
        user.setTrigraph(StringUtils.upperCase((String)trigraph));
        user.clearUserGroups();
        Object[] groups = searchEntry.getAttributeValues("memberOf");
        if (ArrayUtils.isNotEmpty((Object[])groups)) {
            for (Object group : groups) {
                if (groupCache != null) {
                    FaxToMailUserGroup userGroup = groupCache.get(group);
                    if (userGroup == null) continue;
                    user.addUserGroups(userGroup);
                    continue;
                }
                SearchResultEntry groupSearchEntry = adminConnect.getEntry((String)group);
                String objectCategory = groupSearchEntry.getAttributeValue("objectCategory");
                if (!"CN=Group,CN=Schema,CN=Configuration,DC=mac-groupe,DC=net".equals(objectCategory)) continue;
                String groupPath = this.getGroupCompleteName((String)group);
                String groupName = StringUtils.substringAfterLast((String)groupPath, (String)"/");
                FaxToMailUserGroup userGroup = (FaxToMailUserGroup)faxtomailUserGroupDao.forNameEquals(groupName).findUniqueOrNull();
                if (userGroup == null) {
                    userGroup = (FaxToMailUserGroup)faxtomailUserGroupDao.create("name", (Object)groupName, new Object[]{"completeName", groupPath});
                }
                user.addUserGroups(userGroup);
            }
        }
        user = user.isPersisted() ? (FaxToMailUser)faxtomailUserDao.update((TopiaEntity)user) : (FaxToMailUser)faxtomailUserDao.create((TopiaEntity)user);
        user.isAffectedFoldersEmpty();
        user.isUserGroupsEmpty();
        return user;
    }

    @Override
    public List<Contact> getUserAndEmails() {
        ArrayList<Contact> result = new ArrayList<Contact>();
        try (LDAPConnection connection = null;){
            connection = new LDAPConnection(this.getApplicationConfig().getLdapHost(), this.getApplicationConfig().getLdapPort(), this.getApplicationConfig().getLdapUser(), this.getApplicationConfig().getLdapPassword());
            if (connection.isConnected()) {
                FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
                FaxToMailUserGroupTopiaDao faxtomailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
                String usersBaseDN = "OU=Mac-Groupe,DC=mac-groupe,DC=net";
                String usersFilter = "(objectCategory=CN=Person,CN=Schema,CN=Configuration,DC=mac-groupe,DC=net)";
                SearchResult usersResult = connection.search(usersBaseDN, SearchScope.SUB, "(objectClass=organizationalUnit)", new String[0]);
                List unitEntries = usersResult.getSearchEntries();
                for (SearchResultEntry unitEntry : unitEntries) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Search for unit " + unitEntry.getDN()));
                    }
                    SearchResult userResult = connection.search(unitEntry.getDN(), SearchScope.ONE, usersFilter, new String[0]);
                    List userEntries = userResult.getSearchEntries();
                    for (SearchResultEntry userEntry : userEntries) {
                        String name = userEntry.getAttributeValue("displayname");
                        String email = userEntry.getAttributeValue("mail");
                        if (!StringUtils.isNotBlank((CharSequence)email)) continue;
                        result.add(new Contact(name, email));
                    }
                }
            }
        }
        return result;
    }
}

