/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.UserService;
import java.util.List;
import org.hibernate.Hibernate;

public class UserServiceImpl
extends FaxToMailServiceSupport
implements UserService {
    @Override
    public long getActiveUserCount() {
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        long result = faxtomailUserDao.forHiddenEquals(false).count();
        return result;
    }

    @Override
    public long getActiveGroupCount() {
        FaxToMailUserGroupTopiaDao faxtomailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        long result = faxtomailUserGroupDao.forHiddenEquals(false).count();
        return result;
    }

    @Override
    public List<FaxToMailUser> getAllActiveUsers() {
        FaxToMailUserTopiaDao dao = this.getPersistenceContext().getFaxToMailUserDao();
        return dao.forHiddenEquals(false).setOrderByArguments(new String[]{"firstName", "lastName"}).findAll();
    }

    @Override
    public FaxToMailUser getUserByLogin(String login) {
        FaxToMailUserTopiaDao dao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)dao.forLoginEquals(login).findUnique();
        return user;
    }

    @Override
    public List<FaxToMailUserGroup> getAllActiveUserGroups() {
        FaxToMailUserGroupTopiaDao dao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        return dao.forHiddenEquals(false).setOrderByArguments(new String[]{"completeName"}).findAll();
    }

    @Override
    public FaxToMailUser getUser(String topiaId) {
        FaxToMailUserTopiaDao dao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)dao.forTopiaIdEquals(topiaId).findUnique();
        Hibernate.initialize((Object)user.getAffectedFolders());
        return user;
    }
}

