package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Fri Oct 16 14:49:27 CEST 2015")
public abstract class GeneratedEmailTopiaDao<E extends Email> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Email.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.Email;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            HistoryTopiaDao dao = topiaDaoSupplier
                    .getDao(History.class, HistoryTopiaDao.class);
            List<History> list = dao
                    .forProperties(History.PROPERTY_EMAIL, entity)
                    .findAll();
            for (History item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getEmail())) {
                    item.setEmail(null);
                }
            
            }
        }

        {
            AttachmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Attachment.class, AttachmentTopiaDao.class);
            List<Attachment> list = dao
                    .forProperties(Attachment.PROPERTY_EMAIL, entity)
                    .findAll();
            for (Attachment item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getEmail())) {
                    item.setEmail(null);
                }
            
            }
        }

        {
            MailLockTopiaDao dao = topiaDaoSupplier
                    .getDao(MailLock.class, MailLockTopiaDao.class);
            List<MailLock> list = dao
                    .forProperties(MailLock.PROPERTY_LOCK_ON, entity)
                    .findAll();
            for (MailLock item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLockOn())) {
                    item.setLockOn(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(MailFolder mailFolder, OriginalEmail originalEmail) {
        return create(Email.PROPERTY_MAIL_FOLDER, mailFolder, Email.PROPERTY_ORIGINAL_EMAIL, originalEmail);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReceptionDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_RECEPTION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReceptionDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_RECEPTION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByReceptionDate(Date v) {
        return forReceptionDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReceptionDate(Date v) {
        return forReceptionDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdiErrorIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_EDI_ERROR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdiErrorEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_EDI_ERROR, v);
        return result;
    }

    @Deprecated
    public E findByEdiError(String v) {
        return forEdiErrorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEdiError(String v) {
        return forEdiErrorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProjectReferenceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_PROJECT_REFERENCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProjectReferenceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_PROJECT_REFERENCE, v);
        return result;
    }

    @Deprecated
    public E findByProjectReference(String v) {
        return forProjectReferenceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProjectReference(String v) {
        return forProjectReferenceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSenderIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_SENDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSenderEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_SENDER, v);
        return result;
    }

    @Deprecated
    public E findBySender(String v) {
        return forSenderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySender(String v) {
        return forSenderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_FAX, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_FAX, v);
        return result;
    }

    @Deprecated
    public E findByFax(boolean v) {
        return forFaxEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFax(boolean v) {
        return forFaxEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRecipientIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_RECIPIENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRecipientEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_RECIPIENT, v);
        return result;
    }

    @Deprecated
    public E findByRecipient(String v) {
        return forRecipientEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRecipient(String v) {
        return forRecipientEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObjectIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_OBJECT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObjectEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_OBJECT, v);
        return result;
    }

    @Deprecated
    public E findByObject(String v) {
        return forObjectEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByObject(String v) {
        return forObjectEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArchiveDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_ARCHIVE_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArchiveDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_ARCHIVE_DATE, v);
        return result;
    }

    @Deprecated
    public E findByArchiveDate(Date v) {
        return forArchiveDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByArchiveDate(Date v) {
        return forArchiveDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompanyReferenceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_COMPANY_REFERENCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompanyReferenceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_COMPANY_REFERENCE, v);
        return result;
    }

    @Deprecated
    public E findByCompanyReference(String v) {
        return forCompanyReferenceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCompanyReference(String v) {
        return forCompanyReferenceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMailFolderIn(Collection<MailFolder> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_MAIL_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMailFolderEquals(MailFolder v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_MAIL_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByMailFolder(MailFolder v) {
        return forMailFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMailFolder(MailFolder v) {
        return forMailFolderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDemandTypeIn(Collection<DemandType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_DEMAND_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDemandTypeEquals(DemandType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_DEMAND_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByDemandType(DemandType v) {
        return forDemandTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDemandType(DemandType v) {
        return forDemandTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPriorityIn(Collection<Priority> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_PRIORITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPriorityEquals(Priority v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_PRIORITY, v);
        return result;
    }

    @Deprecated
    public E findByPriority(Priority v) {
        return forPriorityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPriority(Priority v) {
        return forPriorityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHistoryContains(History v) {
        return forContains(Email.PROPERTY_HISTORY, v);
    }

    @Deprecated
    public E findContainsHistory(History v) {
        return forHistoryContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsHistory(History v) {
        return forHistoryContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaitingStateIn(Collection<WaitingState> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_WAITING_STATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaitingStateEquals(WaitingState v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_WAITING_STATE, v);
        return result;
    }

    @Deprecated
    public E findByWaitingState(WaitingState v) {
        return forWaitingStateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWaitingState(WaitingState v) {
        return forWaitingStateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTakenByIn(Collection<FaxToMailUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_TAKEN_BY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTakenByEquals(FaxToMailUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_TAKEN_BY, v);
        return result;
    }

    @Deprecated
    public E findByTakenBy(FaxToMailUser v) {
        return forTakenByEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTakenBy(FaxToMailUser v) {
        return forTakenByEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRangeRowContains(RangeRow v) {
        return forContains(Email.PROPERTY_RANGE_ROW, v);
    }

    @Deprecated
    public E findContainsRangeRow(RangeRow v) {
        return forRangeRowContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsRangeRow(RangeRow v) {
        return forRangeRowContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClientIn(Collection<Client> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_CLIENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClientEquals(Client v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_CLIENT, v);
        return result;
    }

    @Deprecated
    public E findByClient(Client v) {
        return forClientEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClient(Client v) {
        return forClientEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDemandStatusIn(Collection<DemandStatus> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_DEMAND_STATUS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDemandStatusEquals(DemandStatus v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_DEMAND_STATUS, v);
        return result;
    }

    @Deprecated
    public E findByDemandStatus(DemandStatus v) {
        return forDemandStatusEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDemandStatus(DemandStatus v) {
        return forDemandStatusEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailGroupIn(Collection<EmailGroup> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_EMAIL_GROUP, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailGroupEquals(EmailGroup v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_EMAIL_GROUP, v);
        return result;
    }

    @Deprecated
    public E findByEmailGroup(EmailGroup v) {
        return forEmailGroupEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEmailGroup(EmailGroup v) {
        return forEmailGroupEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRepliesContains(Reply v) {
        return forContains(Email.PROPERTY_REPLIES, v);
    }

    @Deprecated
    public E findContainsReplies(Reply v) {
        return forRepliesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsReplies(Reply v) {
        return forRepliesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastAttachmentOpenerIn(Collection<FaxToMailUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_LAST_ATTACHMENT_OPENER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastAttachmentOpenerEquals(FaxToMailUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_LAST_ATTACHMENT_OPENER, v);
        return result;
    }

    @Deprecated
    public E findByLastAttachmentOpener(FaxToMailUser v) {
        return forLastAttachmentOpenerEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLastAttachmentOpener(FaxToMailUser v) {
        return forLastAttachmentOpenerEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAttachmentContains(Attachment v) {
        return forContains(Email.PROPERTY_ATTACHMENT, v);
    }

    @Deprecated
    public E findContainsAttachment(Attachment v) {
        return forAttachmentContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsAttachment(Attachment v) {
        return forAttachmentContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOriginalEmailIn(Collection<OriginalEmail> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Email.PROPERTY_ORIGINAL_EMAIL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOriginalEmailEquals(OriginalEmail v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Email.PROPERTY_ORIGINAL_EMAIL, v);
        return result;
    }

    @Deprecated
    public E findByOriginalEmail(OriginalEmail v) {
        return forOriginalEmailEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOriginalEmail(OriginalEmail v) {
        return forOriginalEmailEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMatchingClientsContains(Client v) {
        return forContains(Email.PROPERTY_MATCHING_CLIENTS, v);
    }

    @Deprecated
    public E findContainsMatchingClients(Client v) {
        return forMatchingClientsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMatchingClients(Client v) {
        return forMatchingClientsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Attachment.class) {
            AttachmentTopiaDao dao =
                topiaDaoSupplier.getDao(Attachment.class, AttachmentTopiaDao.class);
            tmp = dao.forEmailEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailLock.class) {
            MailLockTopiaDao dao =
                topiaDaoSupplier.getDao(MailLock.class, MailLockTopiaDao.class);
            tmp = dao.forLockOnEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == History.class) {
            HistoryTopiaDao dao =
                topiaDaoSupplier.getDao(History.class, HistoryTopiaDao.class);
            tmp = dao.forEmailEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EmailGroup.class) {
            EmailGroupTopiaDao dao =
                topiaDaoSupplier.getDao(EmailGroup.class, EmailGroupTopiaDao.class);
            tmp = dao.forEmailContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(Attachment.class, entity);
        if (!list.isEmpty()) {
            result.put(Attachment.class, list);
        }

        list = findUsages(MailLock.class, entity);
        if (!list.isEmpty()) {
            result.put(MailLock.class, list);
        }

        list = findUsages(History.class, entity);
        if (!list.isEmpty()) {
            result.put(History.class, list);
        }

        list = findUsages(EmailGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(EmailGroup.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getRangeRow() != null) {
              tmp.addAll(entity.getRangeRow());
           }
        if (entity.getReplies() != null) {
              tmp.addAll(entity.getReplies());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEmailTopiaDao<E extends Email>
