package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Sep 17 12:43:42 CEST 2015")
public abstract class GeneratedFaxToMailUserGroupTopiaDao<E extends FaxToMailUserGroup> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) FaxToMailUserGroup.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.FaxToMailUserGroup;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.topiaid " +
                    " FROM faxToMailUser main, faxtomailuser_usergroups secondary " +
                    " WHERE main.topiaid=secondary.faxToMailUser " +
                    " AND secondary.userGroups='" + entity.getTopiaId() + "'";
            List<FaxToMailUser> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.FaxToMailUser.getImplementation())
                    .list();

            for (FaxToMailUser item : list) {
                item.removeUserGroups(entity);
            }
        }

        {
            String sql = "SELECT main.topiaid " +
                    " FROM mailFolder main, mailfolder_writerightgroups secondary " +
                    " WHERE main.topiaid=secondary.mailFolder " +
                    " AND secondary.writeRightGroups='" + entity.getTopiaId() + "'";
            List<MailFolder> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.MailFolder.getImplementation())
                    .list();

            for (MailFolder item : list) {
                item.removeWriteRightGroups(entity);
            }
        }

        {
            String sql = "SELECT main.topiaid " +
                    " FROM mailFolder main, mailfolder_moverightgroups secondary " +
                    " WHERE main.topiaid=secondary.mailFolder " +
                    " AND secondary.moveRightGroups='" + entity.getTopiaId() + "'";
            List<MailFolder> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.MailFolder.getImplementation())
                    .list();

            for (MailFolder item : list) {
                item.removeMoveRightGroups(entity);
            }
        }

        {
            String sql = "SELECT main.topiaid " +
                    " FROM mailFolder main, mailfolder_readrightgroups secondary " +
                    " WHERE main.topiaid=secondary.mailFolder " +
                    " AND secondary.readRightGroups='" + entity.getTopiaId() + "'";
            List<MailFolder> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.MailFolder.getImplementation())
                    .list();

            for (MailFolder item : list) {
                item.removeReadRightGroups(entity);
            }
        }

        {
            String sql = "SELECT main.topiaid " +
                    " FROM groupChef main, groupchef_managedgroups secondary " +
                    " WHERE main.topiaid=secondary.groupChef " +
                    " AND secondary.managedGroups='" + entity.getTopiaId() + "'";
            List<GroupChef> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.GroupChef.getImplementation())
                    .list();

            for (GroupChef item : list) {
                item.removeManagedGroups(entity);
            }
        }

        {
            GroupChefTopiaDao dao = topiaDaoSupplier
                    .getDao(GroupChef.class, GroupChefTopiaDao.class);
            List<GroupChef> list = dao
                    .forProperties(GroupChef.PROPERTY_USER_GROUP, entity)
                    .findAll();
            for (GroupChef item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getUserGroup())) {
                    item.setUserGroup(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String name) {
        return forNaturalId(name).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String name) {
        return forNaturalId(name).exists();
    }

    public E createByNaturalId(String name) {
        return create(FaxToMailUserGroup.PROPERTY_NAME, name);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String name) {
        return forProperties(FaxToMailUserGroup.PROPERTY_NAME, name);
    }

    public E createByNotNull(String name) {
        return create(FaxToMailUserGroup.PROPERTY_NAME, name);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUserGroup.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUserGroup.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompleteNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUserGroup.PROPERTY_COMPLETE_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompleteNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUserGroup.PROPERTY_COMPLETE_NAME, v);
        return result;
    }

    @Deprecated
    public E findByCompleteName(String v) {
        return forCompleteNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCompleteName(String v) {
        return forCompleteNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHiddenIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(FaxToMailUserGroup.PROPERTY_HIDDEN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHiddenEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(FaxToMailUserGroup.PROPERTY_HIDDEN, v);
        return result;
    }

    @Deprecated
    public E findByHidden(boolean v) {
        return forHiddenEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByHidden(boolean v) {
        return forHiddenEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GroupChef.class) {
            GroupChefTopiaDao dao =
                topiaDaoSupplier.getDao(GroupChef.class, GroupChefTopiaDao.class);
            tmp = dao.forManagedGroupsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == GroupChef.class) {
            GroupChefTopiaDao dao =
                topiaDaoSupplier.getDao(GroupChef.class, GroupChefTopiaDao.class);
            tmp = dao.forUserGroupEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == FaxToMailUser.class) {
            FaxToMailUserTopiaDao dao =
                topiaDaoSupplier.getDao(FaxToMailUser.class, FaxToMailUserTopiaDao.class);
            tmp = dao.forUserGroupsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forWriteRightGroupsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forMoveRightGroupsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forReadRightGroupsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(GroupChef.class, entity);
        if (!list.isEmpty()) {
            result.put(GroupChef.class, list);
        }

        list = findUsages(FaxToMailUser.class, entity);
        if (!list.isEmpty()) {
            result.put(FaxToMailUser.class, list);
        }

        list = findUsages(MailFolder.class, entity);
        if (!list.isEmpty()) {
            result.put(MailFolder.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedFaxToMailUserGroupTopiaDao<E extends FaxToMailUserGroup>
