package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed Jun 11 16:38:33 CEST 2014")
public abstract class EtatAttenteAbstract extends AbstractTopiaEntity implements EtatAttente {

    /**
     * Nom de l'attribut en BD : label
     */
    protected String label;

    /**
     * Nom de l'attribut en BD : validFormDisabledActions
     */
    protected Collection<MailAction> validFormDisabledActions;

    /**
     * Nom de l'attribut en BD : invalidFormDisabledActions
     */
    protected Collection<MailAction> invalidFormDisabledActions;

    private static final long serialVersionUID = 3545851539332621873L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LABEL, String.class, label);
        visitor.visit(this, PROPERTY_VALID_FORM_DISABLED_ACTIONS, Collection.class, MailAction.class, validFormDisabledActions);
        visitor.visit(this, PROPERTY_INVALID_FORM_DISABLED_ACTIONS, Collection.class, MailAction.class, invalidFormDisabledActions);
        visitor.end(this);
    }

    @Override
    public void setLabel(String label) {
        String oldValue = this.label;
        fireOnPreWrite(PROPERTY_LABEL, oldValue, label);
        this.label = label;
        fireOnPostWrite(PROPERTY_LABEL, oldValue, label);
    }

    @Override
    public String getLabel() {
        fireOnPreRead(PROPERTY_LABEL, label);
        String result = this.label;
        fireOnPostRead(PROPERTY_LABEL, label);
        return result;
    }

    @Override
    public void addValidFormDisabledActions(MailAction validFormDisabledActions) {
        fireOnPreWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, null, validFormDisabledActions);
        if (this.validFormDisabledActions == null) {
            this.validFormDisabledActions = new LinkedList<MailAction>();
        }

        this.validFormDisabledActions.add(validFormDisabledActions);
        fireOnPostWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, this.validFormDisabledActions.size(), null, validFormDisabledActions);
    }

    @Override
    public void addAllValidFormDisabledActions(Collection<MailAction> validFormDisabledActions) {
        if (validFormDisabledActions == null) {
            return;
        }
        for (MailAction item : validFormDisabledActions) {
            addValidFormDisabledActions(item);
        }
    }

    @Override
    public void setValidFormDisabledActions(Collection<MailAction> validFormDisabledActions) {
        // Copy elements to keep data for fire with new reference
        Collection<MailAction> oldValue = this.validFormDisabledActions != null ? new LinkedList<MailAction>(this.validFormDisabledActions) : null;
        fireOnPreWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, oldValue, validFormDisabledActions);
        this.validFormDisabledActions = validFormDisabledActions;
        fireOnPostWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, oldValue, validFormDisabledActions);
    }

    @Override
    public void removeValidFormDisabledActions(MailAction validFormDisabledActions) {
        fireOnPreWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, validFormDisabledActions, null);
        if (this.validFormDisabledActions == null || !this.validFormDisabledActions.remove(validFormDisabledActions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, this.validFormDisabledActions.size() + 1, validFormDisabledActions, null);
    }

    @Override
    public void clearValidFormDisabledActions() {
        if (this.validFormDisabledActions == null) {
            return;
        }
        Collection<MailAction> oldValue = new LinkedList<MailAction>(this.validFormDisabledActions);
        fireOnPreWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, oldValue, this.validFormDisabledActions);
        this.validFormDisabledActions.clear();
        fireOnPostWrite(PROPERTY_VALID_FORM_DISABLED_ACTIONS, oldValue, this.validFormDisabledActions);
    }

    @Override
    public Collection<MailAction> getValidFormDisabledActions() {
        return validFormDisabledActions;
    }

    @Override
    public int sizeValidFormDisabledActions() {
        if (validFormDisabledActions == null) {
            return 0;
        }
        return validFormDisabledActions.size();
    }

    @Override
    public boolean isValidFormDisabledActionsEmpty() {
        int size = sizeValidFormDisabledActions();
        return size == 0;
    }

    @Override
    public boolean isValidFormDisabledActionsNotEmpty() {
        boolean empty = isValidFormDisabledActionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsValidFormDisabledActions(MailAction validFormDisabledActions) {
        boolean contains = this.validFormDisabledActions !=null && this.validFormDisabledActions.contains(validFormDisabledActions);
        return contains;
    }

    @Override
    public void addInvalidFormDisabledActions(MailAction invalidFormDisabledActions) {
        fireOnPreWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, null, invalidFormDisabledActions);
        if (this.invalidFormDisabledActions == null) {
            this.invalidFormDisabledActions = new LinkedList<MailAction>();
        }

        this.invalidFormDisabledActions.add(invalidFormDisabledActions);
        fireOnPostWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, this.invalidFormDisabledActions.size(), null, invalidFormDisabledActions);
    }

    @Override
    public void addAllInvalidFormDisabledActions(Collection<MailAction> invalidFormDisabledActions) {
        if (invalidFormDisabledActions == null) {
            return;
        }
        for (MailAction item : invalidFormDisabledActions) {
            addInvalidFormDisabledActions(item);
        }
    }

    @Override
    public void setInvalidFormDisabledActions(Collection<MailAction> invalidFormDisabledActions) {
        // Copy elements to keep data for fire with new reference
        Collection<MailAction> oldValue = this.invalidFormDisabledActions != null ? new LinkedList<MailAction>(this.invalidFormDisabledActions) : null;
        fireOnPreWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, oldValue, invalidFormDisabledActions);
        this.invalidFormDisabledActions = invalidFormDisabledActions;
        fireOnPostWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, oldValue, invalidFormDisabledActions);
    }

    @Override
    public void removeInvalidFormDisabledActions(MailAction invalidFormDisabledActions) {
        fireOnPreWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, invalidFormDisabledActions, null);
        if (this.invalidFormDisabledActions == null || !this.invalidFormDisabledActions.remove(invalidFormDisabledActions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, this.invalidFormDisabledActions.size() + 1, invalidFormDisabledActions, null);
    }

    @Override
    public void clearInvalidFormDisabledActions() {
        if (this.invalidFormDisabledActions == null) {
            return;
        }
        Collection<MailAction> oldValue = new LinkedList<MailAction>(this.invalidFormDisabledActions);
        fireOnPreWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, oldValue, this.invalidFormDisabledActions);
        this.invalidFormDisabledActions.clear();
        fireOnPostWrite(PROPERTY_INVALID_FORM_DISABLED_ACTIONS, oldValue, this.invalidFormDisabledActions);
    }

    @Override
    public Collection<MailAction> getInvalidFormDisabledActions() {
        return invalidFormDisabledActions;
    }

    @Override
    public int sizeInvalidFormDisabledActions() {
        if (invalidFormDisabledActions == null) {
            return 0;
        }
        return invalidFormDisabledActions.size();
    }

    @Override
    public boolean isInvalidFormDisabledActionsEmpty() {
        int size = sizeInvalidFormDisabledActions();
        return size == 0;
    }

    @Override
    public boolean isInvalidFormDisabledActionsNotEmpty() {
        boolean empty = isInvalidFormDisabledActionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsInvalidFormDisabledActions(MailAction invalidFormDisabledActions) {
        boolean contains = this.invalidFormDisabledActions !=null && this.invalidFormDisabledActions.contains(invalidFormDisabledActions);
        return contains;
    }

} //EtatAttenteAbstract
